/*
 * Decompiled with CFR 0.152.
 */
package fuzs.skeletonaifix;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEvents;
import fuzs.skeletonaifix.config.ServerConfig;
import fuzs.skeletonaifix.init.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkeletonAIFix
implements ModConstructor {
    public static final String MOD_ID = "skeletonaifix";
    public static final String MOD_NAME = "Skeleton AI Fix";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Skeleton AI Fix");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"skeletonaifix").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        SkeletonAIFix.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        LivingEvents.TICK.register(SkeletonAIFix::onEndEntityTick);
    }

    private static EventResult onEndEntityTick(LivingEntity entity) {
        AbstractSkeleton abstractSkeleton;
        if (entity instanceof AbstractSkeleton && (abstractSkeleton = (AbstractSkeleton)entity).m_6095_().m_204039_(ModRegistry.WELL_BEHAVED_SKELETONS_ENTITY_TYPE_TAG)) {
            RangedBowAttackGoal bowGoal = abstractSkeleton.f_32130_;
            bowGoal.f_25790_ = Integer.MIN_VALUE;
            LivingEntity livingEntity = abstractSkeleton.m_5448_();
            if (livingEntity != null) {
                double attackInterval = SkeletonAIFix.getAttackInterval(abstractSkeleton);
                double distanceToTargetSqr = abstractSkeleton.m_20280_((Entity)livingEntity);
                int minAttackInterval = SkeletonAIFix.getMinAttackInterval(attackInterval, distanceToTargetSqr, bowGoal.f_25785_);
                bowGoal.m_25797_(minAttackInterval);
            }
        }
        return EventResult.PASS;
    }

    private static double getAttackInterval(AbstractSkeleton abstractSkeleton) {
        double attackInterval = abstractSkeleton.m_9236_().m_46791_() == Difficulty.HARD ? 40.0 : 20.0;
        return attackInterval *= ((ServerConfig)SkeletonAIFix.CONFIG.get(ServerConfig.class)).attackIntervalMultiplier;
    }

    private static int getMinAttackInterval(double attackInterval, double distanceToTargetSqr, double attackRadiusSqr) {
        double distanceScale = ((ServerConfig)SkeletonAIFix.CONFIG.get(ServerConfig.class)).attackIntervalDistanceScale;
        double baseAttackInterval = attackInterval * (1.0 - distanceScale);
        double attackRadiusScale = SkeletonAIFix.easeOutQuad(Math.min(distanceToTargetSqr / attackRadiusSqr, 1.0));
        double scaledAttackInterval = attackInterval * distanceScale * attackRadiusScale;
        return (int)(baseAttackInterval + scaledAttackInterval);
    }

    static double easeOutQuad(double x) {
        return 1.0 - (1.0 - x) * (1.0 - x);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

