/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ConfectionOvenBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.GingerbreadManEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ConfectionOvenBlockEntity
extends BlockEntity {
    private int cooldown;
    private int gingerbreadSpawns;
    private int spawnIteratesBy = 1;
    private int gingerbreadTeamColor;
    private boolean wasPowered;
    private static final int COOKING_TIME = 100;
    private static final int COOLDOWN_TIME = 300;
    private static final int ARMY_SIZE = 5;
    private List<GingerbreadManEntity> spawnedGingerbreads = new ArrayList<GingerbreadManEntity>();

    public ConfectionOvenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.CONFECTION_OVEN.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ConfectionOvenBlockEntity entity) {
        int targetCookState;
        boolean powered = entity.isActivated(state);
        if (powered && entity.cooldown == 0) {
            entity.cooldown = -100;
            DyeColor dyeColor = ConfectionOvenBlockEntity.getDyeColorFromRockCandy(level, blockPos, state);
            entity.gingerbreadTeamColor = dyeColor != null ? dyeColor.m_41071_() : (int)(Math.random() * 1.6777215E7);
            entity.gingerbreadSpawns = 5;
            entity.spawnIteratesBy = 20;
        }
        if (entity.wasPowered != powered) {
            entity.wasPowered = powered;
            entity.m_6596_();
        }
        boolean flag = false;
        if (entity.cooldown < 0) {
            ++entity.cooldown;
            entity.makeGingerbreadMen();
            if (level.f_46441_.m_188501_() < 0.55f) {
                ConfectionOvenBlockEntity.makeParticles((ParticleOptions)ParticleTypes.f_123777_, level, blockPos, state, true);
            }
            if (entity.cooldown == 0) {
                entity.restoreAllGingerbreadMenCooldown();
                entity.cooldown = 300;
            }
        }
        if (entity.cooldown > 0) {
            if (level.f_46441_.m_188501_() < 0.55f) {
                ConfectionOvenBlockEntity.makeParticles((ParticleOptions)ParticleTypes.f_123762_, level, blockPos, state, false);
            }
            --entity.cooldown;
        }
        int cookState = (Integer)state.m_61143_((Property)ConfectionOvenBlock.COOKSTATE);
        int n = entity.cooldown < 0 ? 1 : (targetCookState = entity.cooldown > 0 ? 2 : 0);
        if (cookState != targetCookState) {
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)ConfectionOvenBlock.COOKSTATE, (Comparable)Integer.valueOf(targetCookState)), 3);
        }
    }

    private void makeGingerbreadMen() {
        if (this.cooldown % this.spawnIteratesBy == 0 && this.gingerbreadSpawns > 0) {
            GingerbreadManEntity gingerbreadMan = (GingerbreadManEntity)((EntityType)ACEntityRegistry.GINGERBREAD_MAN.get()).m_20615_(this.f_58857_);
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)ConfectionOvenBlock.FACING);
            Vec3 spawnVec = ConfectionOvenBlockEntity.rotateCenteredVec(new Vec3(0.0, -0.25, (double)-0.7f), facing);
            gingerbreadMan.m_146884_(spawnVec.m_82549_(this.m_58899_().m_252807_()));
            gingerbreadMan.m_20256_(spawnVec.m_82490_(0.25).m_82520_(0.0, 0.3, 0.0));
            gingerbreadMan.m_146922_(facing.m_122435_());
            gingerbreadMan.setVariant(this.f_58857_.f_46441_.m_188503_(9));
            gingerbreadMan.setOvenSpawned(true);
            gingerbreadMan.setGingerbreadTeamColor(this.gingerbreadTeamColor);
            gingerbreadMan.setDespawnFromOvenCooldown(100);
            if (!this.f_58857_.f_46443_) {
                gingerbreadMan.f_19812_ = true;
                this.f_58857_.m_7967_((Entity)gingerbreadMan);
            }
            this.spawnedGingerbreads.add(gingerbreadMan);
            --this.gingerbreadSpawns;
        }
    }

    private void restoreAllGingerbreadMenCooldown() {
        for (GingerbreadManEntity gingerbreadMan : this.spawnedGingerbreads) {
            gingerbreadMan.setDespawnFromOvenCooldown(300);
        }
        this.spawnedGingerbreads.clear();
    }

    public boolean isActivated(BlockState state) {
        return state.m_60713_((Block)ACBlockRegistry.CONFECTION_OVEN.get()) && (Boolean)state.m_61143_((Property)ConfectionOvenBlock.POWERED) != false;
    }

    @Nullable
    public static DyeColor getDyeColorFromRockCandy(Level level, BlockPos pos, BlockState blockState) {
        Direction facing = (Direction)blockState.m_61143_((Property)ConfectionOvenBlock.FACING);
        BlockPos beneathPos = facing == Direction.UP ? pos.m_122019_() : (facing == Direction.DOWN ? pos.m_122012_() : pos.m_7495_());
        BlockState state = level.m_8055_(beneathPos);
        if (state.m_204336_(ACTagRegistry.ROCK_CANDIES)) {
            if (state.m_60713_((Block)ACBlockRegistry.WHITE_ROCK_CANDY.get())) {
                return DyeColor.WHITE;
            }
            if (state.m_60713_((Block)ACBlockRegistry.ORANGE_ROCK_CANDY.get())) {
                return DyeColor.ORANGE;
            }
            if (state.m_60713_((Block)ACBlockRegistry.MAGENTA_ROCK_CANDY.get())) {
                return DyeColor.MAGENTA;
            }
            if (state.m_60713_((Block)ACBlockRegistry.LIGHT_BLUE_ROCK_CANDY.get())) {
                return DyeColor.LIGHT_BLUE;
            }
            if (state.m_60713_((Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get())) {
                return DyeColor.YELLOW;
            }
            if (state.m_60713_((Block)ACBlockRegistry.PINK_ROCK_CANDY.get())) {
                return DyeColor.PINK;
            }
            if (state.m_60713_((Block)ACBlockRegistry.GRAY_ROCK_CANDY.get())) {
                return DyeColor.GRAY;
            }
            if (state.m_60713_((Block)ACBlockRegistry.LIGHT_GRAY_ROCK_CANDY.get())) {
                return DyeColor.LIGHT_GRAY;
            }
            if (state.m_60713_((Block)ACBlockRegistry.CYAN_ROCK_CANDY.get())) {
                return DyeColor.CYAN;
            }
            if (state.m_60713_((Block)ACBlockRegistry.PURPLE_ROCK_CANDY.get())) {
                return DyeColor.PURPLE;
            }
            if (state.m_60713_((Block)ACBlockRegistry.BLUE_ROCK_CANDY.get())) {
                return DyeColor.BLUE;
            }
            if (state.m_60713_((Block)ACBlockRegistry.BROWN_ROCK_CANDY.get())) {
                return DyeColor.BROWN;
            }
            if (state.m_60713_((Block)ACBlockRegistry.GREEN_ROCK_CANDY.get())) {
                return DyeColor.GREEN;
            }
            if (state.m_60713_((Block)ACBlockRegistry.RED_ROCK_CANDY.get())) {
                return DyeColor.RED;
            }
            if (state.m_60713_((Block)ACBlockRegistry.BLACK_ROCK_CANDY.get())) {
                return DyeColor.BLACK;
            }
        }
        return null;
    }

    private static void makeParticles(ParticleOptions particleOptions, Level level, BlockPos pos, BlockState blockState, boolean top) {
        Direction facing = (Direction)blockState.m_61143_((Property)ConfectionOvenBlock.FACING);
        Vec3 offset = top ? new Vec3((double)(0.4f * (level.f_46441_.m_188501_() - 0.5f)), 0.5, (double)(0.16000001f * (level.f_46441_.m_188501_() - 0.5f))) : new Vec3((double)(0.4f * (level.f_46441_.m_188501_() - 0.5f)), (double)-0.15f, (double)(-0.5f - 0.1f * level.f_46441_.m_188501_()));
        Vec3 rotate = ConfectionOvenBlockEntity.rotateCenteredVec(offset, facing);
        level.m_7106_(particleOptions, rotate.f_82479_ + 0.5 + (double)pos.m_123341_(), rotate.f_82480_ + 0.5 + (double)pos.m_123342_(), rotate.f_82481_ + 0.5 + (double)pos.m_123343_(), 0.0, (double)(0.025f + level.f_46441_.m_188501_() * 0.01f), 0.0);
    }

    private static Vec3 rotateCenteredVec(Vec3 offset, Direction facing) {
        Vec3 rotate = offset;
        switch (facing) {
            case DOWN: {
                rotate = offset.m_82496_(1.5707964f);
                break;
            }
            case UP: {
                rotate = offset.m_82496_(-1.5707964f);
                break;
            }
            case NORTH: {
                rotate = offset;
                break;
            }
            case SOUTH: {
                rotate = offset.m_82524_((float)Math.PI);
                break;
            }
            case WEST: {
                rotate = offset.m_82524_(1.5707964f);
                break;
            }
            case EAST: {
                rotate = offset.m_82524_(-1.5707964f);
            }
        }
        return rotate;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cooldown = tag.m_128451_("Cooldown");
        this.gingerbreadTeamColor = tag.m_128451_("TeamColor");
        this.gingerbreadSpawns = tag.m_128451_("GingerbreadSpawns");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Cooldown", this.cooldown);
        tag.m_128405_("TeamColor", this.gingerbreadTeamColor);
        tag.m_128405_("GingerbreadSpawns", this.gingerbreadSpawns);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.cooldown = packet.m_131708_().m_128451_("Cooldown");
            this.gingerbreadTeamColor = packet.m_131708_().m_128451_("TeamColor");
            this.gingerbreadSpawns = packet.m_131708_().m_128451_("GingerbreadSpawns");
        }
    }
}

