/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MetalScaffoldingBlock
extends Block
implements BucketPickup,
LiquidBlockContainer {
    private static final VoxelShape STABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE_BOTTOM;
    private static final VoxelShape BELOW_BLOCK;
    public static final int STABILITY_MAX_DISTANCE = 12;
    public static final IntegerProperty DISTANCE;
    public static final IntegerProperty LIQUID_LOGGED;
    public static final BooleanProperty BOTTOM;

    public MetalScaffoldingBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60955_().m_60913_(5.0f, 15.0f).m_60918_(ACSoundTypes.METAL_SCAFFOLDING));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(12))).m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, LIQUID_LOGGED, BOTTOM});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return this.isScaffoldingItem(context.m_43722_());
    }

    public boolean isScaffoldingItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_().m_49966_().m_204336_(ACTagRegistry.SCAFFOLDING);
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        int i = MetalScaffoldingBlock.getDistance((BlockGetter)level, blockpos);
        int fluid = this.getLiquidType(level.m_6425_(blockpos));
        BlockState defaultState = fluid == 2 ? ((Block)ACBlockRegistry.RUSTY_SCAFFOLDING.get()).m_49966_() : this.m_49966_();
        return (BlockState)((BlockState)((BlockState)defaultState.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(fluid))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)level, blockpos, i)));
    }

    private int getLiquidType(FluidState fluidState) {
        if (fluidState.m_76152_() == Fluids.f_76193_) {
            return 1;
        }
        if (fluidState.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get() && fluidState.m_76170_()) {
            return 2;
        }
        return 0;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState blockState, boolean forced) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos pos, BlockPos pos1) {
        int liquidType = (Integer)blockState.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 1) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        } else if (liquidType == 2) {
            levelAccessor.m_186469_(pos, (Fluid)ACFluidRegistry.ACID_FLUID_SOURCE.get(), ((FlowingFluid)ACFluidRegistry.ACID_FLUID_SOURCE.get()).m_6718_((LevelReader)levelAccessor));
        }
        if (!levelAccessor.m_5776_()) {
            levelAccessor.m_186460_(pos, (Block)this, 1);
        }
        return blockState;
    }

    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        int i = MetalScaffoldingBlock.getDistance((BlockGetter)level, pos);
        BlockState blockstate = (BlockState)((BlockState)blockState.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)level, pos, i)));
        if ((Integer)blockstate.m_61143_((Property)DISTANCE) == 12) {
            if ((Integer)blockState.m_61143_((Property)DISTANCE) == 12) {
                FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)blockstate);
            } else {
                level.m_46961_(pos, true);
            }
        } else if (blockState != blockstate) {
            level.m_7731_(pos, blockstate, 3);
        }
    }

    public boolean m_7898_(BlockState p_56040_, LevelReader p_56041_, BlockPos p_56042_) {
        return MetalScaffoldingBlock.getDistance((BlockGetter)p_56041_, p_56042_) < 12;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (context.m_6513_(Shapes.m_83144_(), pos, true) && !context.m_6226_()) {
            return STABLE_SHAPE;
        }
        return (Integer)state.m_61143_((Property)DISTANCE) != 0 && (Boolean)state.m_61143_((Property)BOTTOM) != false && context.m_6513_(BELOW_BLOCK, pos, true) ? UNSTABLE_SHAPE_BOTTOM : Shapes.m_83040_();
    }

    public FluidState m_5888_(BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        return liquidType == 1 ? Fluids.f_76193_.m_76068_(false) : (liquidType == 2 ? ((FlowingFluid)ACFluidRegistry.ACID_FLUID_SOURCE.get()).m_76068_(false) : super.m_5888_(state));
    }

    private boolean isBottom(BlockGetter getter, BlockPos pos, int dist) {
        return dist > 0 && !getter.m_8055_(pos.m_7495_()).m_60713_((Block)this);
    }

    public boolean isScaffolding(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public static int getDistance(BlockGetter getter, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_().m_122173_(Direction.DOWN);
        BlockState blockstate = getter.m_8055_((BlockPos)blockpos$mutableblockpos);
        int i = 12;
        if (blockstate.m_60713_(Blocks.f_50616_)) {
            i = (Integer)blockstate.m_61143_((Property)ScaffoldingBlock.f_56012_);
        } else if (blockstate.m_60734_() instanceof MetalScaffoldingBlock) {
            i = (Integer)blockstate.m_61143_((Property)DISTANCE);
        } else if (blockstate.m_204336_(ACTagRegistry.SCAFFOLDING) || blockstate.m_60783_(getter, (BlockPos)blockpos$mutableblockpos, Direction.UP)) {
            return 0;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate1 = getter.m_8055_((BlockPos)blockpos$mutableblockpos.m_122159_((Vec3i)pos, direction));
            if (!blockstate1.m_204336_(ACTagRegistry.SCAFFOLDING)) continue;
            if (blockstate1.m_60734_() instanceof MetalScaffoldingBlock) {
                i = Math.min(i, (Integer)blockstate1.m_61143_((Property)DISTANCE) + 1);
            } else if (blockstate1.m_60734_() instanceof ScaffoldingBlock) {
                i = Math.min(i, (Integer)blockstate1.m_61143_((Property)ScaffoldingBlock.f_56012_) + 1);
            }
            if (i != 1) continue;
            break;
        }
        return i;
    }

    public boolean m_6044_(BlockGetter getter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return fluid == Fluids.f_76193_ || fluid.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get();
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState blockState, FluidState fluidState) {
        int liquidType = (Integer)blockState.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 0) {
            if (!levelAccessor.m_5776_()) {
                if (fluidState.m_76152_() == Fluids.f_76193_) {
                    levelAccessor.m_7731_(pos, (BlockState)blockState.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(1)), 3);
                } else if (fluidState.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
                    BlockState state = blockState;
                    if (blockState.m_60734_() == ACBlockRegistry.METAL_SCAFFOLDING.get()) {
                        levelAccessor.m_46796_(1501, pos, 0);
                        state = (BlockState)((Block)ACBlockRegistry.RUSTY_SCAFFOLDING.get()).m_49966_().m_61124_((Property)DISTANCE, (Comparable)((Integer)blockState.m_61143_((Property)DISTANCE)));
                    }
                    levelAccessor.m_7731_(pos, (BlockState)state.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(2)), 3);
                }
                levelAccessor.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)levelAccessor));
            }
            return true;
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType > 0) {
            levelAccessor.m_7731_(blockPos, (BlockState)state.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0)), 3);
            if (!state.m_60710_((LevelReader)levelAccessor, blockPos)) {
                levelAccessor.m_46961_(blockPos, true);
            }
            return new ItemStack((ItemLike)(liquidType == 1 ? Items.f_42447_ : (ItemLike)ACItemRegistry.ACID_BUCKET.get()));
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    static {
        UNSTABLE_SHAPE_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        BELOW_BLOCK = Shapes.m_83144_().m_83216_(0.0, -1.0, 0.0);
        DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)0, (int)12);
        LIQUID_LOGGED = IntegerProperty.m_61631_((String)"liquid_logged", (int)0, (int)2);
        BOTTOM = BlockStateProperties.f_61427_;
        VoxelShape voxelshape = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0);
        VoxelShape voxelshape2 = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape4 = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        STABLE_SHAPE = Shapes.m_83124_((VoxelShape)voxelshape, (VoxelShape[])new VoxelShape[]{voxelshape1, voxelshape2, voxelshape3, voxelshape4});
        VoxelShape voxelshape5 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape6 = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape8 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
        UNSTABLE_SHAPE = Shapes.m_83124_((VoxelShape)UNSTABLE_SHAPE_BOTTOM, (VoxelShape[])new VoxelShape[]{STABLE_SHAPE, voxelshape6, voxelshape5, voxelshape8, voxelshape7});
    }
}

