/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BoneRibsBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty UNDER = BooleanProperty.m_61465_((String)"under");
    public final Map<BlockState, VoxelShape> shapeMap = new HashMap<BlockState, VoxelShape>();
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BoneRibsBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60999_().m_60978_(2.0f).m_60918_(SoundType.f_56724_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UNDER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    protected VoxelShape getRibsShape(BlockState state) {
        if (this.shapeMap.containsKey(state)) {
            return this.shapeMap.get(state);
        }
        VoxelShape merge = (Boolean)state.m_61143_((Property)UNDER) != false ? SHAPE_BOTTOM : SHAPE_TOP;
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                merge = Shapes.m_83113_((VoxelShape)merge, (VoxelShape)SHAPE_NORTH, (BooleanOp)BooleanOp.f_82695_);
                break;
            }
            case EAST: {
                merge = Shapes.m_83113_((VoxelShape)merge, (VoxelShape)SHAPE_EAST, (BooleanOp)BooleanOp.f_82695_);
                break;
            }
            case SOUTH: {
                merge = Shapes.m_83113_((VoxelShape)merge, (VoxelShape)SHAPE_SOUTH, (BooleanOp)BooleanOp.f_82695_);
                break;
            }
            case WEST: {
                merge = Shapes.m_83113_((VoxelShape)merge, (VoxelShape)SHAPE_WEST, (BooleanOp)BooleanOp.f_82695_);
            }
        }
        this.shapeMap.put(state, merge);
        return merge;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getRibsShape(state);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos blockPos) {
        return 1.0f;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean under;
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Vec3 vec3 = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
        BlockState placedOn = levelaccessor.m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
        Direction facing = context.m_43719_().m_122434_().m_122479_() ? context.m_43719_() : context.m_8125_().m_122424_();
        boolean bl = under = context.m_43719_() == Direction.DOWN || vec3.f_82480_ < 0.5;
        if (placedOn.m_60713_((Block)this) && context.m_43719_().m_122434_().m_122478_()) {
            facing = (Direction)placedOn.m_61143_((Property)f_54117_);
            under = (Boolean)placedOn.m_61143_((Property)UNDER) == false;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)UNDER, (Comparable)Boolean.valueOf(under));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{WATERLOGGED, UNDER, f_54117_});
    }

    public PushReaction getPistonPushReaction(BlockState blockState) {
        return PushReaction.DESTROY;
    }
}

