/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_attributes.compat.apotheosis;

import com.mojang.datafixers.util.Pair;
import de.cadentem.additional_attributes.compat.apotheosis.ApothAttributes;
import de.cadentem.additional_attributes.compat.apotheosis.RarityDefinition;
import de.cadentem.additional_attributes.config.ServerConfig;
import de.cadentem.additional_attributes.datagen.AAItemTags;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AffixUtils {
    public static void affixItem(ItemStack stack, Player player) {
        DynamicHolder min;
        if (player == null || stack.m_41619_()) {
            return;
        }
        if (stack.m_204117_(AAItemTags.APOTH_CRAFTING_BLACKLIST)) {
            return;
        }
        double crafting = player.m_21133_((Attribute)ApothAttributes.APOTHIC_CRAFTING.get());
        if (crafting == 0.0 || LootCategory.forItem((ItemStack)stack) == LootCategory.NONE) {
            return;
        }
        if (crafting < 1.0 && player.m_217043_().m_188500_() > crafting) {
            return;
        }
        List rarities = RarityRegistry.INSTANCE.getOrderedRarities();
        if (rarities.isEmpty()) {
            return;
        }
        int rounded = (int)Math.min((double)((Integer)ServerConfig.MAX_RARITY.get()).intValue(), Math.floor(crafting));
        if (crafting >= 1.0) {
            --rounded;
        }
        DynamicHolder max = min = rounded < rarities.size() ? (DynamicHolder)rarities.get(rounded) : RarityRegistry.getMaxRarity();
        if (AffixUtils.shouldIncreaseRarity(player.m_217043_(), crafting)) {
            max = RarityRegistry.next((DynamicHolder)max);
        }
        for (int shift = 0; shift < (Integer)ServerConfig.SHIFT_MIN_RARITY.get(); ++shift) {
            min = RarityRegistry.prev((DynamicHolder)min);
        }
        Pair<DynamicHolder<LootRarity>, DynamicHolder<LootRarity>> clamp = RarityDefinition.clamp(stack, (DynamicHolder<LootRarity>)min, (DynamicHolder<LootRarity>)max);
        LootRarity rarity = LootRarity.random((RandomSource)player.m_217043_(), (float)player.m_36336_(), (RarityClamp)new RarityClamp.Simple((DynamicHolder)clamp.getFirst(), (DynamicHolder)clamp.getSecond()));
        LootController.createLootItem((ItemStack)stack, (LootRarity)rarity, (RandomSource)player.m_217043_());
    }

    private static boolean shouldIncreaseRarity(RandomSource random, double crafting) {
        int clamped = (int)crafting;
        double remainder = crafting - (double)clamped;
        if (crafting < 1.0 || remainder == 0.0 || crafting >= (double)RarityRegistry.INSTANCE.getOrderedRarities().size()) {
            return false;
        }
        return random.m_188500_() < remainder;
    }
}

