/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.network;

import com.legacy.lost_aether.capability.entity.IWingedAnimal;
import com.legacy.lost_aether.capability.entity.WingedAnimalCap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SetWingTypePacket {
    private final int entityId;
    private final byte wingType;

    public SetWingTypePacket(int entityIdIn, byte id) {
        this.entityId = entityIdIn;
        this.wingType = id;
    }

    public static void encoder(SetWingTypePacket packet, FriendlyByteBuf buff) {
        buff.writeInt(packet.entityId);
        buff.writeByte((int)packet.wingType);
    }

    public static SetWingTypePacket decoder(FriendlyByteBuf buff) {
        return new SetWingTypePacket(buff.readInt(), buff.readByte());
    }

    public static void handler(SetWingTypePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SetWingTypePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SetWingTypePacket packet) {
        Animal animal;
        IWingedAnimal cap;
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId);
        if (entity instanceof Animal && (cap = WingedAnimalCap.get(animal = (Animal)entity)) != null) {
            cap.setWingType(packet.wingType);
        }
    }
}

