/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.ie;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAIContext;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizedAIGunner;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.AttackDelayConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.BulletMode;
import steve_gall.minecolonies_compatibility.module.common.ie.Bullet;
import steve_gall.minecolonies_compatibility.module.common.ie.DefaultBullet;
import steve_gall.minecolonies_compatibility.module.common.ie.IEConfig;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class GunnerRevolverAI
extends CustomizedAIGunner {
    public static final String TAG_KEY = MineColoniesCompatibility.rl("ie_gunner_revolver").toString();

    @Override
    public boolean test(@NotNull CustomizedAIContext context) {
        return super.test(context) && context.getWeapon().m_41720_() instanceof RevolverItem;
    }

    @Override
    protected boolean testAmmo(@NotNull AbstractEntityCitizen user, @NotNull ItemStack stack) {
        return stack.m_41720_() instanceof BulletItem;
    }

    @Override
    @Nullable
    protected IDeliverableObject createAmmoRequest(@NotNull AbstractEntityCitizen user, int minCount) {
        return new Bullet(minCount);
    }

    @Override
    protected boolean isAmmoRequest(@NotNull AbstractEntityCitizen user, @NotNull IDeliverableObject object) {
        return object instanceof Bullet;
    }

    @Override
    public boolean canMeleeAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        return true;
    }

    @Override
    public boolean reload(@NotNull AbstractEntityCitizen user, boolean forRangedAttack) {
        if (((Boolean)this.getWeaponConfig().needReload.get()).booleanValue() && this.getBulletCount(user) <= 0) {
            this.startReloadTimer(user);
            return false;
        }
        return true;
    }

    @Override
    protected void onReloadTimerStarted(@NotNull AbstractEntityCitizen user) {
        super.onReloadTimerStarted(user);
        user.m_5496_((SoundEvent)IESounds.revolverReload.get(), 1.0f, 1.0f);
    }

    @Override
    protected void onReloadTimerStopped(@NotNull AbstractEntityCitizen user, boolean complete) {
        super.onReloadTimerStopped(user, complete);
        if (complete) {
            this.setBulletCount(user, 8);
        }
    }

    @Override
    public float getMeleeAttackDamage(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        ItemStack weapon = this.getMainHandItem(user);
        double melee = RevolverItem.getUpgradeValue_d((ItemStack)weapon, (String)"melee");
        float damage = super.getMeleeAttackDamage(user, target);
        if (melee != 0.0) {
            damage += (float)melee;
        }
        return damage;
    }

    @Override
    public void doRangedAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        IEConfig.JobConfig.GunnerRevolverConfig config = this.getWeaponConfig();
        BulletMode bulletMode = this.getBulletMode();
        IItemHandler inventory = user.getItemHandlerCitizen();
        int bulletSlot = this.getAmmoSlot(user, inventory);
        ItemStack weapon = this.getMainHandItem(user);
        Level level = user.m_9236_();
        ItemStack bullet = null;
        DefaultBullet bulletType = null;
        if (bulletMode.canUse() && bulletSlot > -1) {
            bullet = inventory.extractItem(bulletSlot, 1, false);
            bulletType = ((BulletItem)bullet.m_41720_()).getType();
        } else if (bulletMode.canDefault()) {
            bullet = ItemStack.f_41583_.m_41777_();
            bulletType = DefaultBullet.INSTANCE;
            DefaultBullet.putDamage(bullet, config.defaultBulletDamage.apply(user, this.getPrimarySkillLevel(user)));
        }
        if (bulletType != null && bullet != null) {
            float noise = RevolverItem.fireProjectile((Level)level, (LivingEntity)user, (ItemStack)weapon, (BulletHandler.IBullet)bulletType, (ItemStack)bullet);
            this.insertItem(user, inventory, bulletType.getCasing(bullet).m_41777_());
            if (((Boolean)config.occurNoise.get()).booleanValue()) {
                Utils.attractEnemies((LivingEntity)user, (float)(64.0f * noise));
                if (noise > 0.2f) {
                    GameEvent eventTriggered = noise > 0.5f ? GameEvent.f_157812_ : GameEvent.f_157778_;
                    level.m_214171_(eventTriggered, user.m_20182_(), GameEvent.Context.m_223717_((Entity)user));
                }
            }
        } else {
            user.m_5496_((SoundEvent)SoundEvents.f_12215_.get(), 1.0f, 1.0f);
        }
        if (((Boolean)config.needReload.get()).booleanValue()) {
            this.setBulletCount(user, this.getBulletCount(user) - 1);
        }
    }

    @Override
    @Nullable
    protected AttackDelayConfig getAttackDealyConfig() {
        return this.getWeaponConfig().attackDelay;
    }

    @Override
    public double getAttackDistance(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        RevolverItem item;
        ItemStack weapon = this.getMainHandItem(user);
        double distance = super.getAttackDistance(user, target);
        Item item2 = weapon.m_41720_();
        if (item2 instanceof RevolverItem && (item = (RevolverItem)item2).canZoom(weapon, null)) {
            distance *= ((Double)this.getWeaponConfig().scopeRangeMultiplier.get()).doubleValue();
        }
        return distance;
    }

    @Override
    public double getHorizontalSearchRange(@NotNull AbstractEntityCitizen user) {
        RevolverItem item;
        ItemStack weapon = this.getMainHandItem(user);
        double range = super.getHorizontalSearchRange(user);
        Item item2 = weapon.m_41720_();
        if (item2 instanceof RevolverItem && (item = (RevolverItem)item2).canZoom(weapon, null)) {
            range *= ((Double)this.getWeaponConfig().scopeRangeMultiplier.get()).doubleValue();
        }
        return range;
    }

    @Override
    @NotNull
    public String getTagKey() {
        return TAG_KEY;
    }

    public IEConfig.JobConfig.GunnerRevolverConfig getWeaponConfig() {
        return MineColoniesCompatibilityConfigServer.INSTANCE.modules.IE.job.gunnerRevolver;
    }

    public int getBulletCount(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).m_128451_("bulletCount");
    }

    public void setBulletCount(@NotNull AbstractEntityCitizen user, int count) {
        this.getOrCreateTag(user).m_128405_("bulletCount", Math.max(count, 0));
    }

    @Override
    protected int getReloadTimerDuration() {
        return (Integer)this.getWeaponConfig().reloadDuration.get();
    }
}

