/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.ai.workers.production.herders.AbstractEntityAIHerder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.ButchercraftModule;

@Mixin(value={AbstractEntityAIHerder.class}, remap=false)
public abstract class AbstractEntityAIHerderMixin<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractEntityAIInteract<J, B> {
    public AbstractEntityAIHerderMixin(@NotNull J job) {
        super(job);
    }

    @Inject(method={"getExtraToolsNeeded"}, remap=false, at={@At(value="TAIL")}, cancellable=true)
    private void getExtraToolsNeeded(CallbackInfoReturnable<List<EquipmentTypeEntry>> cir) {
        boolean changed = false;
        ArrayList<EquipmentTypeEntry> newList = new ArrayList<EquipmentTypeEntry>();
        for (EquipmentTypeEntry toolType : (List)cir.getReturnValue()) {
            if (toolType == ModEquipmentTypes.axe.get()) {
                newList.add(ModToolTypes.BUTCHER_TOOL.getToolType());
                changed = true;
                continue;
            }
            newList.add(toolType);
        }
        if (changed) {
            cir.setReturnValue(newList);
        }
    }

    @ModifyVariable(method={"getToolSlot"}, remap=false, at=@At(value="HEAD"), ordinal=0)
    private EquipmentTypeEntry getToolSlot(EquipmentTypeEntry toolType) {
        if (toolType == ModEquipmentTypes.axe.get()) {
            return ModToolTypes.BUTCHER_TOOL.getToolType();
        }
        return toolType;
    }

    @WrapOperation(method={"butcherAnimal"}, remap=false, at={@At(value="INVOKE", target="getFakePlayer")})
    private FakePlayer butcherAnimal_getFakePlayer(AbstractEntityAIHerder<?, ?> self, Operation<FakePlayer> operation) {
        FakePlayer player = (FakePlayer)operation.call(new Object[]{self});
        InteractionHand hand = InteractionHand.MAIN_HAND;
        player.m_21008_(hand, this.worker.m_21120_(hand).m_41777_());
        return player;
    }

    @WrapOperation(method={"butcherSwing"}, remap=false, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Animal;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", remap=true)})
    private boolean butcherSwing_hurt(Animal animal, DamageSource source, float damage, Operation<Boolean> operation) {
        Entity entity;
        DamageType damageType = (DamageType)((Registry)this.worker.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_6246_(DamageTypes.f_268464_);
        if (source.m_269415_() == damageType && (entity = source.m_7639_()) instanceof FakePlayer) {
            FakePlayer player = (FakePlayer)entity;
            if (ModuleManager.BUTCHERCRAFT.isLoaded() && ButchercraftModule.slaughter(player, animal, InteractionHand.MAIN_HAND)) {
                return true;
            }
        }
        return (Boolean)operation.call(new Object[]{animal, source, Float.valueOf(damage)});
    }
}

