/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class TeachRecipeMenuNewRecipesMessage
extends AbstractMessage {
    private final List<CompoundTag> recipes;

    public TeachRecipeMenuNewRecipesMessage(List<CompoundTag> recipes) {
        this.recipes = ImmutableList.copyOf(recipes);
    }

    public TeachRecipeMenuNewRecipesMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.recipes = buffer.m_236845_(FriendlyByteBuf::m_130260_);
    }

    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_236828_(this.recipes, FriendlyByteBuf::m_130079_);
    }

    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        Minecraft mc = Minecraft.m_91087_();
        AbstractContainerMenu abstractContainerMenu = mc.f_91074_.f_36096_;
        if (abstractContainerMenu instanceof TeachRecipeMenu) {
            TeachRecipeMenu menu = (TeachRecipeMenu)abstractContainerMenu;
            List<Object> recipes = this.recipes.stream().map(r -> menu.getRecipeValidator().deserialize((IFactoryController)StandardFactoryController.getInstance(), (CompoundTag)r)).toList();
            menu.onNewRecipesTransfer(recipes);
        }
    }

    public List<CompoundTag> getRecipes() {
        return this.recipes;
    }
}

