/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_compatibility.core.common.block.entity.IAccessDirectionHolder;
import steve_gall.minecolonies_compatibility.core.common.building.module.AccessDirection;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class AccessDirectionMessage<BLOCK_ENTITY extends BlockEntity>
extends AbstractMessage {
    private final BlockPos position;
    private final AccessDirection accessDirection;

    public AccessDirectionMessage(BLOCK_ENTITY blockEntity, AccessDirection accessDirection) {
        this.position = blockEntity.m_58899_();
        this.accessDirection = accessDirection;
    }

    public AccessDirectionMessage(FriendlyByteBuf buffer) {
        this.position = buffer.m_130135_();
        this.accessDirection = (AccessDirection)buffer.m_130066_(AccessDirection.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130064_(this.position);
        buffer.m_130068_((Enum)this.accessDirection);
    }

    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        BlockEntity blockEntity = player.m_9236_().m_7702_(this.position);
        if (blockEntity instanceof IAccessDirectionHolder) {
            IAccessDirectionHolder holder = (IAccessDirectionHolder)blockEntity;
            holder.setAccessDirection(this.accessDirection);
        }
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public AccessDirection getAccessDirection() {
        return this.accessDirection;
    }
}

