/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.crafting.BucketFillingGenericRecipe;

public class BucketFillingRecipeStorage
extends GenericedRecipeStorage<BucketFillingGenericRecipe> {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("bucket_filling");
    public static String TAG_EMPTY_BUCKET = "emptyBucket";
    public static String TAG_FLUID = "fluid";
    public static String TAG_FLUID_AMOUNT = "fluidAmount";
    public static String TAG_FLUID_TAG = "fluidTag";
    public static String TAG_FILLED_BUCKET = "filledBucket";
    private final ItemStack emptyBucket;
    private final Fluid fluid;
    private final int fluidAmount;
    private final CompoundTag fluidTag;
    private final ItemStack filledBucket;
    private final List<ItemStorage> input;
    private final BucketFillingGenericRecipe recipe;

    public static void serialize(IFactoryController controller, CompoundTag tag, BucketFillingRecipeStorage recipe) {
        tag.m_128365_(TAG_EMPTY_BUCKET, (Tag)recipe.emptyBucket.serializeNBT());
        tag.m_128359_(TAG_FLUID, ForgeRegistries.FLUIDS.getKey((Object)recipe.fluid).toString());
        tag.m_128405_(TAG_FLUID_AMOUNT, recipe.fluidAmount);
        if (recipe.fluidTag != null) {
            tag.m_128365_(TAG_FLUID_TAG, (Tag)recipe.fluidTag);
        }
        tag.m_128365_(TAG_FILLED_BUCKET, (Tag)recipe.filledBucket.serializeNBT());
    }

    public static BucketFillingRecipeStorage deserialize(IFactoryController controller, CompoundTag tag) {
        ItemStack emptyBucket = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_EMPTY_BUCKET));
        ResourceLocation fluidId = new ResourceLocation(tag.m_128461_(TAG_FLUID));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        int fluidAmount = tag.m_128441_(TAG_FLUID_AMOUNT) ? tag.m_128451_(TAG_FLUID_AMOUNT) : 1000;
        CompoundTag fluidTag = tag.m_128441_(TAG_FLUID_TAG) ? tag.m_128469_(TAG_FLUID_TAG) : null;
        ItemStack filledBucket = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_FILLED_BUCKET));
        return new BucketFillingRecipeStorage(emptyBucket, fluid, fluidAmount, fluidTag, filledBucket);
    }

    public BucketFillingRecipeStorage(ItemStack emptyBucket, Fluid fluid, int fluidAmount, CompoundTag fluidTag, ItemStack filledBucket) {
        this.emptyBucket = emptyBucket;
        this.fluid = fluid;
        this.fluidAmount = fluidAmount;
        this.fluidTag = fluidTag;
        this.filledBucket = filledBucket;
        this.input = Collections.singletonList(new ItemStorage(emptyBucket));
        this.recipe = new BucketFillingGenericRecipe(emptyBucket, fluid, fluidAmount, fluidTag, filledBucket);
    }

    public int hashCode() {
        return Objects.hash(this.emptyBucket.m_41720_().hashCode(), this.fluid.hashCode(), this.fluidAmount, this.fluidTag == null ? 0 : this.fluidTag.hashCode(), this.filledBucket.m_41720_().hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BucketFillingRecipeStorage) {
            BucketFillingRecipeStorage other = (BucketFillingRecipeStorage)o;
            return ItemStack.m_41728_((ItemStack)this.emptyBucket, (ItemStack)other.emptyBucket) && this.fluid == other.fluid && this.fluidAmount == other.fluidAmount && Objects.equals(this.fluidTag, other.fluidTag) && ItemStack.m_41728_((ItemStack)this.filledBucket, (ItemStack)other.filledBucket);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getEmptyBucket() {
        return this.emptyBucket;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public CompoundTag getFluidTag() {
        return this.fluidTag;
    }

    public FluidStack getFluidStack() {
        return this.getFluidStack(this.fluidAmount);
    }

    public FluidStack getFluidStack(int amount) {
        return new FluidStack(this.fluid, amount, this.fluidTag);
    }

    public ItemStack getFilledBucket() {
        return this.filledBucket;
    }

    public List<ItemStorage> getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public BucketFillingGenericRecipe getGenericRecipe() {
        return this.recipe;
    }
}

