/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.block.entity;

import com.minecolonies.api.util.WorldUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.block.entity.IAccessDirectionHolder;
import steve_gall.minecolonies_compatibility.core.common.block.entity.INetworkStorageViewHolder;
import steve_gall.minecolonies_compatibility.core.common.building.module.AccessDirection;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.QueueNetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.init.ModBlockEntities;
import steve_gall.minecolonies_compatibility.core.common.init.ModItems;
import steve_gall.minecolonies_compatibility.core.common.item.CombinedItemHandler;
import steve_gall.minecolonies_compatibility.core.common.item.ItemHandlerHelper2;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackCounter;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackKey;

public class CommonNetworkStorageBlockEntity
extends BlockEntity
implements INetworkStorageViewHolder,
IAccessDirectionHolder {
    private final StorageView view;
    private final ItemStackCounter counter;
    private AccessDirection accessDirection = AccessDirection.INSERT_EXTRACT;

    public CommonNetworkStorageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.COMMON_NETWORK_STORAGE.get(), pos, state);
        this.view = new StorageView();
        this.counter = new ItemStackCounter();
        this.counter.addListener(this::onCounterChanged);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.view.readLink(compound.m_128469_("view"));
        this.accessDirection = AccessDirection.deserialize(compound.m_128423_("accessDirection"));
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("view", (Tag)this.view.writeLink());
        compound.m_128365_("accessDirection", this.accessDirection.serialize());
    }

    @Override
    @NotNull
    public INetworkStorageView getNetworkStorageView() {
        return this.view;
    }

    @Override
    @NotNull
    public AccessDirection getAccessDirection() {
        return this.accessDirection;
    }

    @Override
    public void setAccessDirection(@NotNull AccessDirection value) {
        if (this.accessDirection != value) {
            this.accessDirection = value;
            this.view.requestAll();
            this.m_6596_();
        }
    }

    public void m_6596_() {
        Level level = this.f_58857_;
        if (level != null) {
            WorldUtil.markChunkDirty((Level)level, (BlockPos)this.m_58899_());
        }
        super.m_6596_();
    }

    public void update() {
        Iterable<Object2LongMap.Entry<ItemStackKey>> stacks = this.getStacks();
        this.counter.replace(stacks);
    }

    private void onCounterChanged(ItemStackKey key, long oldCount, long newCount) {
        if (oldCount < newCount) {
            this.view.enqueue(key.getStack(newCount));
        }
    }

    private Iterable<Object2LongMap.Entry<ItemStackKey>> getStacks() {
        IItemHandler handler = this.getCombinedHandler();
        ItemStackCounter counter = new ItemStackCounter();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack == null || stack.m_41619_()) continue;
            ItemStackKey key = new ItemStackKey(stack);
            counter.insert(key, stack.m_41613_());
        }
        return counter.entrySet();
    }

    public IItemHandler getCombinedHandler() {
        BlockPos pos = this.m_58899_();
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        for (Direction direction : Direction.values()) {
            IItemHandler handler;
            LazyOptional cap;
            BlockEntity be = this.f_58857_.m_7702_(pos.m_121945_(direction));
            if (be == null || (cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_())) == null || !cap.isPresent() || (handler = (IItemHandler)cap.orElse(null)) == null) continue;
            handlers.add(handler);
        }
        return new CombinedItemHandler((IItemHandler[])handlers.toArray(IItemHandler[]::new));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CommonNetworkStorageBlockEntity self) {
        if (!level.m_5776_()) {
            if (level.m_46467_() % 100L == 0L) {
                self.update();
            }
            self.view.onTick();
        }
    }

    public class StorageView
    extends QueueNetworkStorageView {
        @Override
        public Level getLevel() {
            return CommonNetworkStorageBlockEntity.this.f_58857_;
        }

        @Override
        public BlockPos getPos() {
            return CommonNetworkStorageBlockEntity.this.f_58858_;
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return null;
        }

        @Override
        @NotNull
        public ItemStack getIcon() {
            return new ItemStack((ItemLike)ModItems.COMMON_NETWORK_STORAGE.get());
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean canExtract() {
            return CommonNetworkStorageBlockEntity.this.getAccessDirection().canExtract();
        }

        @Override
        public boolean canInsert() {
            return CommonNetworkStorageBlockEntity.this.getAccessDirection().canInsert();
        }

        @Override
        @NotNull
        public Stream<ItemStack> getAllStacks() {
            return CommonNetworkStorageBlockEntity.this.counter.entrySet().stream().map(e -> ((ItemStackKey)e.getKey()).getStack(e.getLongValue()));
        }

        @Override
        public void link(NetworkStorageModule module) {
            super.link(module);
            CommonNetworkStorageBlockEntity.this.m_6596_();
        }

        @Override
        public void unlink() {
            super.unlink();
            CommonNetworkStorageBlockEntity.this.m_6596_();
        }

        @Override
        @NotNull
        public ItemStack extractItem(@NotNull ItemStack stack, boolean simulate) {
            return ItemHandlerHelper2.extractItem(CommonNetworkStorageBlockEntity.this.getCombinedHandler(), stack, simulate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
            return ItemHandlerHelper2.insertItem(CommonNetworkStorageBlockEntity.this.getCombinedHandler(), stack, simulate);
        }
    }
}

