/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.repair;

import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBlacksmith;
import com.minecolonies.core.entity.ai.workers.crafting.EntityAIWorkBlacksmith;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.tool.CustomizedToolSystem;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public abstract class ToolSystemBrokenItem
implements IDeliverableObject {
    private final EntityAIWorkBlacksmith ai;

    public ToolSystemBrokenItem(@Nullable EntityAIWorkBlacksmith ai) {
        this.ai = ai;
    }

    @Nullable
    public EntityAIWorkBlacksmith getAI() {
        return this.ai;
    }

    @NotNull
    public abstract CustomizedToolSystem getToolSystem();

    public int getCount() {
        return 1;
    }

    public boolean matches(@NotNull ItemStack stack) {
        if (this.ai == null) {
            return false;
        }
        CustomizedToolSystem toolSystem = this.getToolSystem();
        return toolSystem.isTool(stack) && toolSystem.isBroken(stack) && ((BuildingBlacksmith)this.ai.building).getBuildingLevel() >= toolSystem.getLevel(stack);
    }
}

