/*
 * Decompiled with CFR 0.152.
 */
package net.mysticdrew.journeymapteams.handlers;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mysticdrew.journeymapteams.Constants;
import net.mysticdrew.journeymapteams.handlers.FTBTeamsHandler;
import net.mysticdrew.journeymapteams.handlers.Handler;
import net.mysticdrew.journeymapteams.handlers.VanillaTeamsHandler;

public enum HandlerManager {
    INSTANCE;

    private final Map<String, Class<? extends Handler>> handlerMap = new HashMap<String, Class<? extends Handler>>();

    private HandlerManager() {
        this.populate();
    }

    private void populate() {
        this.handlerMap.put("minecraft", VanillaTeamsHandler.class);
        this.handlerMap.put("ftbteams", FTBTeamsHandler.class);
    }

    public <T extends Handler> void addLoaderHandler(String modId, Class<T> cls) {
        this.handlerMap.put(modId, cls);
    }

    public Handler getHandler(String modId) {
        return this.getHandler(Collections.singletonList(modId));
    }

    public Handler getHandler(List<String> modIds) {
        try {
            for (String modId : modIds) {
                Class<? extends Handler> handler = this.handlerMap.get(modId);
                if (handler == null || "minecraft".equals(modId)) continue;
                return handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.handlerMap.get("minecraft").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Constants.LOGGER.error(String.format("Couldn't initialize teams handler for {}", e));
            return null;
        }
    }
}

