/*
 * Decompiled with CFR 0.152.
 */
package net.mysticdrew.journeymapteams.handlers;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.mysticdrew.journeymapteams.handlers.AbstractHandler;

public class FTBTeamsHandler
extends AbstractHandler {
    public FTBTeamsHandler() {
        super("ftbteams", "prop.category.label.ftb");
    }

    @Override
    public boolean isVisible(Player localPlayer, Player remotePlayer, boolean isOp, boolean visible) {
        Optional localTeam = FTBTeamsAPI.api().getManager().getTeamForPlayerID(localPlayer.m_20148_());
        Optional remoteTeam = FTBTeamsAPI.api().getManager().getTeamForPlayerID(remotePlayer.m_20148_());
        if (localTeam.isPresent() && remoteTeam.isPresent()) {
            boolean allied = ((Team)localTeam.get()).getRankForPlayer(remotePlayer.m_20148_()).isAtLeast(TeamRank.ALLY) || ((Team)remoteTeam.get()).getRankForPlayer(localPlayer.m_20148_()).isAtLeast(TeamRank.ALLY);
            boolean inPlayerTeam = ((Team)remoteTeam.get()).isPlayerTeam() && !((Team)remoteTeam.get()).isPartyTeam();
            boolean sameTeam = ((Team)remoteTeam.get()).getTeamId().equals(((Team)localTeam.get()).getTeamId());
            if (sameTeam || allied || isOp || inPlayerTeam) {
                return visible;
            }
            return false;
        }
        if (localTeam.isEmpty() && remoteTeam.isPresent() && !isOp) {
            return false;
        }
        return visible;
    }

    @Override
    protected int getRemotePlayerColor(Player remotePlayer) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        Optional knownRemotePlayer = FTBTeamsAPI.api().getClientManager().getKnownPlayer(remotePlayer.m_20148_());
        Optional knownLocalPlayer = FTBTeamsAPI.api().getClientManager().getKnownPlayer(localPlayer.m_20148_());
        if (knownRemotePlayer.isPresent() && knownLocalPlayer.isPresent()) {
            Optional remoteTeam = FTBTeamsAPI.api().getClientManager().getTeamByID(((KnownClientPlayer)knownRemotePlayer.get()).teamId());
            Optional localTeam = FTBTeamsAPI.api().getClientManager().getTeamByID(((KnownClientPlayer)knownLocalPlayer.get()).teamId());
            if (localTeam.isPresent() && remoteTeam.isPresent()) {
                boolean allied = ((Team)localTeam.get()).getRankForPlayer(remotePlayer.m_20148_()).isAtLeast(TeamRank.ALLY) || ((Team)remoteTeam.get()).getRankForPlayer(localPlayer.m_20148_()).isAtLeast(TeamRank.ALLY);
                boolean teammates = ((Team)remoteTeam.get()).getId() == ((Team)localTeam.get()).getId();
                return this.getColor(teammates, allied, ((Color4I)((Team)remoteTeam.get()).getProperty((TeamProperty)TeamProperties.COLOR)).rgb());
            }
        }
        return this.properties.getTeamColor();
    }
}

