/*
 * Decompiled with CFR 0.152.
 */
package net.mysticdrew.journeymapteams.client.integration;

import java.util.EnumSet;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.RegistryEvent;
import journeymap.client.api.model.WrappedEntity;
import net.minecraft.world.entity.player.Player;
import net.mysticdrew.journeymapteams.handlers.Handler;

public class JourneyMapCommonPlugin {
    private static JourneyMapCommonPlugin instance;
    private final Handler handler;

    public JourneyMapCommonPlugin(Handler handler) {
        this.handler = handler;
    }

    public static void init(Handler handler) {
        instance = new JourneyMapCommonPlugin(handler);
    }

    public static JourneyMapCommonPlugin getInstance() {
        if (instance == null) {
            throw new UnsupportedOperationException("Common Plugin is not initialized");
        }
        return instance;
    }

    public void handleEvents(ClientEvent clientEvent) {
        if (!ClientEvent.Type.REGISTRY.equals((Object)clientEvent.type) || ((RegistryEvent)clientEvent).getRegistryType().equals((Object)RegistryEvent.RegistryType.OPTIONS)) {
            // empty if block
        }
    }

    public static void registerEvents(IClientAPI api) {
        api.subscribe("journeymapteams", EnumSet.of(ClientEvent.Type.REGISTRY));
    }

    public void setPlayerColor(WrappedEntity entity) {
        entity.setColor(this.handler.getRemotePlayerIconColor((Player)entity.getEntityLivingRef().get(), entity.getColor()));
    }
}

