/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.rei;

import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.rei.ReiBaseCategory;
import com.yanny.ali.rei.ReiGameplayDisplay;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ReiGameplayCategory
extends ReiBaseCategory<ReiGameplayDisplay, ResourceLocation> {
    private static final int OFFSET = 10;
    private final CategoryIdentifier<ReiGameplayDisplay> identifier;
    private final Component title;
    private final ItemStack icon;

    public ReiGameplayCategory(CategoryIdentifier<ReiGameplayDisplay> identifier, Component title, LootCategory<ResourceLocation> lootCategory) {
        super(lootCategory);
        this.identifier = identifier;
        this.title = title;
        this.icon = lootCategory.getIcon().m_7968_();
    }

    @Override
    public List<Widget> setupDisplay(ReiGameplayDisplay display, Rectangle bounds) {
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        String key = "ali/loot_table/" + display.getId().m_135815_();
        Component lootName = GenericUtils.ellipsis(key, display.getId().m_135815_(), bounds.width);
        MutableComponent fullText = Component.m_237113_((String)display.getId().toString());
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)lootName);
        ReiBaseCategory.WidgetHolder holder = this.getBaseWidget(display, new Rectangle(0, 0, bounds.width, bounds.height), 10);
        int with = Mth.m_14045_((int)holder.bounds().getWidth(), (int)textWidth, (int)bounds.width);
        int innerWidth = with % 2 == 0 ? with : with + 1;
        Rectangle innerBounds = new Rectangle(0, 0, innerWidth, holder.bounds().getHeight() + 10);
        int height = Math.min(innerBounds.height + 8, bounds.height - 8);
        Rectangle fullBounds = new Rectangle(0, 0, innerBounds.width + 8, height);
        LinkedList<Widget> innerWidgets = new LinkedList<Widget>(holder.widgets());
        fullBounds.move(bounds.getCenterX() - fullBounds.width / 2, bounds.y + 4);
        innerWidgets.add((Widget)Widgets.createLabel((Point)new Point(innerBounds.getCenterX(), 0), (Component)lootName).noShadow().color(0).tooltip(new Component[]{fullText}));
        widgets.add((Widget)Widgets.createCategoryBase((Rectangle)fullBounds));
        if (bounds.height >= innerBounds.height + 8) {
            innerBounds.move(bounds.getCenterX() - innerBounds.width / 2, bounds.y + 8);
            widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.concat(innerWidgets), (double)(bounds.getCenterX() - Math.round((float)innerBounds.width / 2.0f)), (double)(bounds.y + 8), (double)0.0));
        } else {
            Rectangle overflowBounds = new Rectangle(fullBounds.x + 4, fullBounds.y + 4, fullBounds.width - 8, fullBounds.height - 8);
            widgets.add((Widget)Widgets.overflowed((Rectangle)overflowBounds, (WidgetWithBounds)Widgets.concatWithBounds((Rectangle)innerBounds, innerWidgets)));
        }
        return widgets;
    }

    public CategoryIdentifier<ReiGameplayDisplay> getCategoryIdentifier() {
        return this.identifier;
    }

    public Component getTitle() {
        return this.title;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemStack)this.icon);
    }
}

