/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.rei;

import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.EntityStorage;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.rei.ReiBaseCategory;
import com.yanny.ali.rei.ReiEntityDisplay;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ReiEntityCategory
extends ReiBaseCategory<ReiEntityDisplay, EntityType<?>> {
    private static final int WIDGET_SIZE = 36;
    private static final int TEXT_OFFSET = 10;
    private static final int OFFSET = 50;
    private final CategoryIdentifier<ReiEntityDisplay> identifier;
    private final Component title;
    private final ItemStack icon;

    public ReiEntityCategory(CategoryIdentifier<ReiEntityDisplay> identifier, Component title, LootCategory<EntityType<?>> lootCategory) {
        super(lootCategory);
        this.identifier = identifier;
        this.title = title;
        this.icon = lootCategory.getIcon().m_7968_();
    }

    @Override
    public List<Widget> setupDisplay(ReiEntityDisplay display, Rectangle bounds) {
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        Rect rect = new Rect(0, 0, 36, 36);
        Component entityLabel = display.getEntityType().m_20676_();
        SpawnEggItem spawnEgg = SpawnEggItem.m_43213_(display.getEntityType());
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)entityLabel);
        ReiBaseCategory.WidgetHolder holder = this.getBaseWidget(display, new Rectangle(0, 0, bounds.width, bounds.height), 50);
        int with = Mth.m_14045_((int)Math.max(holder.bounds().getWidth(), textWidth), (int)80, (int)bounds.width);
        int innerWidth = with % 2 == 0 ? with : with + 1;
        Rectangle innerBounds = new Rectangle(0, 0, innerWidth, holder.bounds().getHeight() + 50);
        int height = Math.min(innerBounds.height + 8, bounds.height - 8);
        Rectangle fullBounds = new Rectangle(0, 0, innerBounds.width + 8, height);
        LinkedList<Widget> innerWidgets = new LinkedList<Widget>(holder.widgets());
        if (spawnEgg != null) {
            innerWidgets.add((Widget)Widgets.createSlot((Point)new Point(innerBounds.getX() + 1, innerBounds.getY() + 10 + 1)).entry(EntryStacks.of((ItemLike)spawnEgg)).markInput());
        }
        innerWidgets.add((Widget)Widgets.wrapRenderer((Rectangle)new Rectangle(innerBounds.getCenterX() - 18, 10, 36, 36), (graphics, bounds1, mouseX, mouseY, delta) -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                Entity entity = EntityStorage.getEntity(PluginManager.COMMON_REGISTRY, display.getEntityType(), (Level)level, display.getVariant());
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)bounds1.getX(), (float)bounds1.getY(), 0.0f);
                GenericUtils.renderEntity(entity, rect, 162, graphics, mouseX + innerBounds.width / 2, mouseY);
                graphics.m_280168_().m_85849_();
            }
        }));
        innerWidgets.add((Widget)Widgets.createLabel((Point)new Point(innerBounds.getCenterX(), 0), (Component)display.getEntityType().m_20676_()));
        fullBounds.move(bounds.getCenterX() - fullBounds.width / 2, bounds.y + 4);
        widgets.add((Widget)Widgets.createCategoryBase((Rectangle)fullBounds));
        if (bounds.height >= innerBounds.height + 8) {
            innerBounds.move(bounds.getCenterX() - innerBounds.width / 2, bounds.y + 8);
            widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.concat(innerWidgets), (double)(bounds.getCenterX() - Math.round((float)innerBounds.width / 2.0f)), (double)(bounds.y + 8), (double)0.0));
        } else {
            Rectangle overflowBounds = new Rectangle(fullBounds.x + 4, fullBounds.y + 4, fullBounds.width - 8, fullBounds.height - 8);
            widgets.add((Widget)Widgets.overflowed((Rectangle)overflowBounds, (WidgetWithBounds)Widgets.concatWithBounds((Rectangle)innerBounds, innerWidgets)));
        }
        return widgets;
    }

    public CategoryIdentifier<ReiEntityDisplay> getCategoryIdentifier() {
        return this.identifier;
    }

    public Component getTitle() {
        return this.title;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemStack)this.icon);
    }
}

