/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ErrorTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    public static ItemStack getItemStack(IServerUtils utils, ItemStack itemStack, List<LootItemFunction> functions) {
        for (LootItemFunction function : functions) {
            itemStack = utils.applyItemStackModifier(utils, function, itemStack);
        }
        return itemStack;
    }

    public static void applyRandomChance(IServerUtils utils, LootItemRandomChanceCondition condition, Map<Enchantment, Map<Integer, RangeValue>> chance) {
        for (Map.Entry<Enchantment, Map<Integer, RangeValue>> chanceMap : chance.entrySet()) {
            for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                levelEntry.getValue().multiply(condition.f_81921_);
            }
        }
    }

    public static void applyRandomChanceWithLooting(IServerUtils utils, LootItemRandomChanceWithLootingCondition condition, Map<Enchantment, Map<Integer, RangeValue>> chance) {
        Enchantment enchantment = Enchantments.f_44982_;
        if (chance.containsKey(enchantment)) {
            chance.get(null).get(0).multiply(condition.f_81953_);
            for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                entry.getValue().multiply(condition.f_81953_ + (float)entry.getKey().intValue() * condition.f_81954_);
            }
        } else {
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.f_81953_);
            chance.put(enchantment, levelMap);
            for (int level = 1; level <= enchantment.m_6586_(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(condition.f_81953_ + (float)level * condition.f_81954_));
            }
        }
    }

    public static void applyTableBonus(IServerUtils utils, BonusLevelTableCondition condition, Map<Enchantment, Map<Integer, RangeValue>> chance) {
        block2: {
            Enchantment enchantment;
            block3: {
                enchantment = condition.f_81507_;
                if (condition.f_81508_.length <= 0) break block2;
                if (!chance.containsKey(enchantment)) break block3;
                chance.get(null).get(0).multiply(condition.f_81508_[0]);
                if (condition.f_81508_.length <= 1) break block2;
                for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                    Integer level = entry.getKey();
                    if (level >= condition.f_81508_.length) continue;
                    entry.getValue().multiply(condition.f_81508_[level]);
                }
                break block2;
            }
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.f_81508_[0]);
            chance.put(enchantment, levelMap);
            for (int level = 1; level <= enchantment.m_6586_() && level < condition.f_81508_.length; ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(condition.f_81508_[level]));
            }
        }
    }

    public static void applySetCount(IServerUtils utils, SetItemCountFunction function, Map<Enchantment, Map<Integer, RangeValue>> count) {
        if (function.f_80676_.length == 0) {
            for (Map.Entry<Enchantment, Map<Integer, RangeValue>> chanceMap : count.entrySet()) {
                for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                    if (function.f_165407_) {
                        levelEntry.getValue().add(utils.convertNumber(utils, function.f_80997_));
                        continue;
                    }
                    levelEntry.getValue().set(utils.convertNumber(utils, function.f_80997_));
                }
            }
        }
    }

    public static void applyBonus(IServerUtils utils, ApplyBonusCount function, Map<Enchantment, Map<Integer, RangeValue>> count) {
        block4: {
            if (function.f_80676_.length != 0) break block4;
            Enchantment enchantment = function.f_79899_;
            if (count.containsKey(enchantment)) {
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    TooltipUtils.calculateCount(function, entry.getValue(), entry.getKey());
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                count.put(enchantment, levelMap);
                for (int level = 1; level <= enchantment.m_6586_(); ++level) {
                    RangeValue value = new RangeValue(baseCount);
                    TooltipUtils.calculateCount(function, value, level);
                    levelMap.put(level, value);
                }
            }
        }
    }

    public static void applyLimitCount(IServerUtils utils, LimitCount function, Map<Enchantment, Map<Integer, RangeValue>> bonusCount) {
        if (function.f_80676_.length == 0) {
            for (Map.Entry<Enchantment, Map<Integer, RangeValue>> entry : bonusCount.entrySet()) {
                for (Map.Entry<Integer, RangeValue> mapEntry : entry.getValue().entrySet()) {
                    RangeValue value = mapEntry.getValue();
                    value.clamp(utils.convertNumber(utils, function.f_80635_.f_165001_), utils.convertNumber(utils, function.f_80635_.f_165002_));
                }
            }
        }
    }

    public static void applyLootingEnchant(IServerUtils utils, LootingEnchantFunction function, Map<Enchantment, Map<Integer, RangeValue>> count) {
        block5: {
            if (function.f_80676_.length != 0) break block5;
            Enchantment enchantment = Enchantments.f_44982_;
            if (count.containsKey(enchantment)) {
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    RangeValue value = entry.getValue();
                    value.add(utils.convertNumber(utils, function.f_80776_).multiply(entry.getKey().intValue()));
                    if (function.f_80777_ <= 0) continue;
                    value.clamp(new RangeValue(false, true), new RangeValue(function.f_80777_));
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                count.put(enchantment, levelMap);
                for (int level = 1; level <= enchantment.m_6586_(); ++level) {
                    RangeValue value = new RangeValue(baseCount).add(utils.convertNumber(utils, function.f_80776_).multiply(level));
                    if (function.f_80777_ > 0) {
                        value.clamp(new RangeValue(false, true), new RangeValue(function.f_80777_));
                    }
                    levelMap.put(level, value);
                }
            }
        }
    }

    @NotNull
    public static ItemStack applyEnchantRandomlyItemStackModifier(IServerUtils utils, EnchantRandomlyFunction function, ItemStack itemStack) {
        if (itemStack.m_41792_() && function.f_80676_.length == 0) {
            boolean isBook = itemStack.m_150930_(Items.f_42517_);
            ItemStack finalItemStack = itemStack;
            List<Enchantment> enchantments = function.f_80415_;
            if (enchantments.isEmpty()) {
                enchantments = BuiltInRegistries.f_256876_.m_123024_().filter(Enchantment::m_6592_).filter(enchantment -> isBook || enchantment.m_6081_(finalItemStack)).toList();
            }
            if (enchantments.size() == 1 && ((Enchantment)enchantments.get(0)).m_44702_() == enchantments.get(0).m_6586_()) {
                itemStack.m_41663_(enchantments.get(0), enchantments.get(0).m_6586_());
            } else if (isBook) {
                itemStack = Items.f_42690_.m_7968_();
            }
        }
        return itemStack;
    }

    @NotNull
    public static ItemStack applyEnchantWithLevelsItemStackModifier(IServerUtils utils, EnchantWithLevelsFunction function, ItemStack itemStack) {
        if (itemStack.m_41792_() && function.f_80676_.length == 0 && itemStack.m_150930_(Items.f_42517_)) {
            itemStack = Items.f_42690_.m_7968_();
        }
        return itemStack;
    }

    public static ItemStack applySetAttributesItemStackModifier(IServerUtils utils, SetAttributesFunction function, ItemStack itemStack) {
        if (function.f_80676_.length == 0) {
            for (SetAttributesFunction.Modifier modifier : function.f_80831_) {
                UUID id = modifier.f_80851_;
                if (id == null) {
                    id = UUID.randomUUID();
                }
                if (modifier.f_80852_.length != 1 || modifier.f_80850_.m_142587_() != NumberProviders.f_165731_) continue;
                EquipmentSlot equipmentSlot = (EquipmentSlot)Util.m_214670_((Object[])modifier.f_80852_, (RandomSource)RandomSource.m_216327_());
                ConstantValue value = (ConstantValue)modifier.f_80850_;
                itemStack.m_41643_(modifier.f_80848_, new AttributeModifier(id, modifier.f_80847_, (double)value.m_142688_(null), modifier.f_80849_), equipmentSlot);
            }
        }
        return itemStack;
    }

    public static ItemStack applySetNameItemStackModifier(IServerUtils utils, SetNameFunction function, ItemStack itemStack) {
        if (function.f_80676_.length == 0) {
            itemStack.m_41714_(function.f_81123_);
        }
        return itemStack;
    }

    public static ItemStack applyItemStackModifier(IServerUtils utils, LootItemFunction function, ItemStack itemStack) {
        if (function instanceof LootItemConditionalFunction) {
            LootItemConditionalFunction conditional = (LootItemConditionalFunction)function;
            if (conditional.f_80676_.length > 0) {
                return itemStack;
            }
        }
        itemStack = (ItemStack)function.apply((Object)itemStack, null);
        return itemStack;
    }

    public static void addObjectFields(IServerUtils utils, IKeyTooltipNode tooltip, Object object, Class<?> baseClass) {
        if (object.getClass().isEnum()) {
            return;
        }
        List<Field> fields = TooltipUtils.getAllFields(object.getClass(), baseClass);
        List<Field> names = fields.stream().filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            if (f.isSynthetic()) {
                return;
            }
            try {
                IKeyTooltipNode t;
                f.setAccessible(true);
                Object obj = f.get(object);
                if (obj instanceof LootItemCondition) {
                    LootItemCondition condition = (LootItemCondition)obj;
                    t = BranchTooltipNode.branch().add(GenericTooltipUtils.getConditionListTooltip(utils, Collections.singletonList(condition)));
                } else if (obj instanceof LootItemFunction) {
                    LootItemFunction function = (LootItemFunction)obj;
                    t = BranchTooltipNode.branch().add(GenericTooltipUtils.getFunctionListTooltip(utils, Collections.singletonList(function)));
                } else {
                    t = utils.getValueTooltip(utils, obj);
                }
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName() + ":", false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "[" + f.getType().getName() + "]").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static IKeyTooltipNode getArrayTooltip(IServerUtils utils, Object value) {
        Class<?> componentType = value.getClass().getComponentType();
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        int length = Array.getLength(value);
        if (componentType == LootItemCondition.class) {
            ArrayList<LootItemCondition> values = new ArrayList<LootItemCondition>();
            for (int i = 0; i < length; ++i) {
                values.add((LootItemCondition)Array.get(value, i));
            }
            return GenericTooltipUtils.getSubConditionsTooltip(utils, values);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                if (element instanceof LootItemCondition) {
                    LootItemCondition condition = (LootItemCondition)element;
                    tooltip.add(GenericTooltipUtils.getConditionListTooltip(utils, Collections.singletonList(condition)));
                    continue;
                }
                if (element instanceof LootItemFunction) {
                    LootItemFunction function = (LootItemFunction)element;
                    tooltip.add(GenericTooltipUtils.getFunctionListTooltip(utils, Collections.singletonList(function)));
                    continue;
                }
                IKeyTooltipNode t = utils.getValueTooltip(utils, element);
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build("ali.property.value.null"));
                    continue;
                }
                if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build("ali.property.branch.values"));
                    continue;
                }
                if (!(t instanceof ErrorTooltipNode.Builder)) continue;
                tooltip.add(utils.getValueTooltip(utils, element).build("ali.property.value.null"));
            }
        } else {
            return ValueTooltipNode.value("[]");
        }
        return tooltip;
    }

    private static void calculateCount(ApplyBonusCount function, RangeValue value, int level) {
        if (function.f_79900_ instanceof ApplyBonusCount.OreDrops) {
            if (level > 0) {
                value.multiplyMax(level + 1);
            }
        } else {
            ApplyBonusCount.Formula formula = function.f_79900_;
            if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
                ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
                value.addMax(binomialWithBonusCount.f_79948_ + level);
            } else {
                formula = function.f_79900_;
                if (formula instanceof ApplyBonusCount.UniformBonusCount) {
                    ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
                    if (level > 0) {
                        value.addMax(uniformBonusCount.f_80013_ * level);
                    }
                }
            }
        }
    }

    @NotNull
    private static List<Field> getAllFields(Class<?> clazz, Class<?> baseClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != baseClass && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(fields, declaredFields);
        }
        return fields;
    }
}

