/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.snow_real_magic;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class NormalizeNode
implements IDataNode,
IItemNode {
    public static final ResourceLocation ID = new ResourceLocation("snowrealmagic", "item_stack");
    private final ITooltipNode tooltip;
    private final float chance;

    public NormalizeNode(IServerUtils utils, float chance, int quality, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this.tooltip = ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.normalize")).add(NormalizeNode.getItemTooltip(utils, chance, quality, functions, conditions)).build();
        this.chance = chance;
    }

    public NormalizeNode(IClientUtils utils, FriendlyByteBuf buf) {
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.chance = 1.0f;
    }

    @Override
    public void encode(IServerUtils utils, FriendlyByteBuf buf) {
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    private static ITooltipNode getItemTooltip(IServerUtils utils, float chance, int quality, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        Map<Enchantment, Map<Integer, RangeValue>> chanceMap = NodeUtils.getEnchantedChance(utils, conditions, chance);
        Map<Enchantment, Map<Integer, RangeValue>> countMap = NormalizeNode.getCount(utils, 1, functions);
        return EntryTooltipUtils.getTooltip(utils, quality, chanceMap, countMap, functions, conditions);
    }

    @NotNull
    public static Map<Enchantment, Map<Integer, RangeValue>> getCount(IServerUtils utils, int baseCount, List<LootItemFunction> functions) {
        LinkedHashMap<Enchantment, Map<Integer, RangeValue>> count = new LinkedHashMap<Enchantment, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue(baseCount)));
        for (LootItemFunction function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    @Override
    public Either<ItemStack, TagKey<? extends ItemLike>> getModifiedItem() {
        return Either.left((Object)ItemStack.f_41583_);
    }

    @Override
    public List<LootItemCondition> getConditions() {
        return List.of();
    }

    @Override
    public List<LootItemFunction> getFunctions() {
        return List.of();
    }

    @Override
    public RangeValue getCount() {
        return new RangeValue();
    }

    @Override
    public float getChance() {
        return this.chance;
    }
}

