/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods;

import com.google.common.collect.Lists;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.FieldAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtils {
    public static <T extends BaseAccessor<?>> T copyClassData(Class<T> myClass, Object targetObject) {
        try {
            ClassAccessor classAnnotation = myClass.getAnnotation(ClassAccessor.class);
            if (classAnnotation != null) {
                Class<?> targetClass = Class.forName(classAnnotation.value());
                BaseAccessor myObject = (BaseAccessor)ReflectionUtils.createObject(myClass, targetObject);
                for (Field myField : myClass.getDeclaredFields()) {
                    FieldAccessor fieldAnnotation = myField.getAnnotation(FieldAccessor.class);
                    if (fieldAnnotation == null) continue;
                    Optional<Field> optional = ReflectionUtils.getFieldsUpTo(targetClass, Object.class).stream().filter(f -> f.getName().equals(myField.getName())).findFirst();
                    if (optional.isPresent()) {
                        Field targetField = optional.get();
                        targetField.setAccessible(true);
                        myField.setAccessible(true);
                        Object value = targetField.get(targetObject);
                        if (fieldAnnotation.clazz() == Object.class) {
                            myField.set(myObject, value);
                            continue;
                        }
                        myField.set(myObject, ReflectionUtils.copyClassData(fieldAnnotation.clazz(), value));
                        continue;
                    }
                    throw new NoSuchFieldException(myField.getName());
                }
                return (T)myObject;
            }
            throw new IllegalStateException("Class is not annotated with @ClassAccessor");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    private static <T> T createObject(Class<T> myClass, Object object) {
        return (T)Arrays.stream(myClass.getConstructors()).filter(c -> c.getParameterCount() == 1 && c.getParameterTypes()[0].isAssignableFrom(object.getClass())).findFirst().map(c -> {
            c.setAccessible(true);
            try {
                return c.newInstance(object);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).orElseGet(() -> {
            Constructor declaredConstructor;
            try {
                declaredConstructor = myClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            declaredConstructor.setAccessible(true);
            try {
                return declaredConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    private static List<Field> getFieldsUpTo(Class<?> startClass, @Nullable Class<?> exclusiveParent) {
        ArrayList currentClassFields = Lists.newArrayList((Object[])startClass.getDeclaredFields());
        Class<?> parentClass = startClass.getSuperclass();
        if (parentClass != null && !parentClass.equals(exclusiveParent)) {
            List<Field> parentClassFields = ReflectionUtils.getFieldsUpTo(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }
}

