/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.glm;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.glm.IGlobalLootModifierAccessor;
import com.yanny.ali.plugin.glm.IGlobalLootModifierPlugin;
import com.yanny.ali.plugin.glm.IGlobalLootModifierWrapper;
import com.yanny.ali.plugin.glm.ILootTableIdConditionPredicate;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.ReflectionUtils;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.GlobalLootModifierNode;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import org.slf4j.Logger;

public class GlobalLootModifierUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<ILootModifier<?>> getLootModifier(final List<LootItemCondition> conditions, final Function<List<LootItemCondition>, List<IOperation>> operationSupplier, final ILootTableIdConditionPredicate predicate) {
        if (GlobalLootModifierUtils.entityPredicate(conditions)) {
            return Optional.of(new ILootModifier<Entity>(){

                @Override
                public boolean predicate(Entity value) {
                    return GlobalLootModifierUtils.entityPredicate(conditions, value);
                }

                @Override
                public List<IOperation> getOperations() {
                    return (List)operationSupplier.apply(conditions.stream().filter(c -> !GlobalLootModifierUtils.entityPredicate(c)).toList());
                }

                @Override
                public ILootModifier.IType<Entity> getType() {
                    return ILootModifier.IType.ENTITY;
                }
            });
        }
        if (GlobalLootModifierUtils.blockPredicate(conditions)) {
            return Optional.of(new ILootModifier<Block>(){

                @Override
                public boolean predicate(Block value) {
                    return GlobalLootModifierUtils.blockPredicate(conditions, value);
                }

                @Override
                public List<IOperation> getOperations() {
                    return (List)operationSupplier.apply(conditions.stream().filter(c -> !GlobalLootModifierUtils.blockPredicate(c)).toList());
                }

                @Override
                public ILootModifier.IType<Block> getType() {
                    return ILootModifier.IType.BLOCK;
                }
            });
        }
        if (GlobalLootModifierUtils.tablePredicate(conditions, predicate)) {
            return Optional.of(new ILootModifier<ResourceLocation>(){

                @Override
                public boolean predicate(ResourceLocation value) {
                    return GlobalLootModifierUtils.tablePredicate(conditions, value, predicate);
                }

                @Override
                public List<IOperation> getOperations() {
                    return (List)operationSupplier.apply(conditions.stream().filter(c -> !GlobalLootModifierUtils.tablePredicate(c, predicate)).toList());
                }

                @Override
                public ILootModifier.IType<ResourceLocation> getType() {
                    return ILootModifier.IType.LOOT_TABLE;
                }
            });
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean entityPredicate(LootItemCondition c) {
        if (c instanceof LootItemEntityPropertyCondition) {
            LootItemEntityPropertyCondition condition = (LootItemEntityPropertyCondition)c;
            if (condition.f_81847_ == LootContext.EntityTarget.THIS && condition.f_81846_ != EntityPredicate.f_36550_ && condition.f_81846_.f_36551_ != EntityTypePredicate.f_37636_) {
                return true;
            }
        }
        if (!(c instanceof AnyOfCondition)) return false;
        AnyOfCondition condition = (AnyOfCondition)c;
        if (!GlobalLootModifierUtils.entityPredicate(Arrays.asList(condition.f_285609_))) return false;
        return true;
    }

    public static boolean entityPredicate(List<LootItemCondition> conditions) {
        return conditions.stream().anyMatch(GlobalLootModifierUtils::entityPredicate);
    }

    public static boolean entityPredicate(List<LootItemCondition> conditions, Entity entity) {
        return conditions.stream().anyMatch(c -> {
            if (c instanceof LootItemEntityPropertyCondition) {
                LootItemEntityPropertyCondition condition = (LootItemEntityPropertyCondition)c;
                if (condition.f_81847_ == LootContext.EntityTarget.THIS && condition.f_81846_ != EntityPredicate.f_36550_ && condition.f_81846_.f_36551_ != EntityTypePredicate.f_37636_ && condition.f_81846_.f_36551_.m_7484_(entity.m_6095_())) {
                    return true;
                }
            }
            if (!(c instanceof AnyOfCondition)) return false;
            AnyOfCondition condition = (AnyOfCondition)c;
            if (!GlobalLootModifierUtils.entityPredicate(Arrays.asList(condition.f_285609_), entity)) return false;
            return true;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean blockPredicate(LootItemCondition c) {
        if (c instanceof LootItemBlockStatePropertyCondition) {
            return true;
        }
        if (!(c instanceof AnyOfCondition)) return false;
        AnyOfCondition condition = (AnyOfCondition)c;
        if (!GlobalLootModifierUtils.blockPredicate(Arrays.asList(condition.f_285609_))) return false;
        return true;
    }

    public static boolean blockPredicate(List<LootItemCondition> conditions) {
        return conditions.stream().anyMatch(GlobalLootModifierUtils::blockPredicate);
    }

    public static boolean blockPredicate(List<LootItemCondition> conditions, Block block) {
        return conditions.stream().anyMatch(c -> {
            if (c instanceof LootItemBlockStatePropertyCondition) {
                LootItemBlockStatePropertyCondition condition = (LootItemBlockStatePropertyCondition)c;
                if (condition.f_81759_.equals(block)) {
                    return true;
                }
            }
            if (!(c instanceof AnyOfCondition)) return false;
            AnyOfCondition condition = (AnyOfCondition)c;
            if (!GlobalLootModifierUtils.blockPredicate(Arrays.asList(condition.f_285609_), block)) return false;
            return true;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean tablePredicate(LootItemCondition c, ILootTableIdConditionPredicate predicate) {
        if (predicate.isLootTableIdCondition(c)) {
            return true;
        }
        if (!(c instanceof AnyOfCondition)) return false;
        AnyOfCondition condition = (AnyOfCondition)c;
        if (!GlobalLootModifierUtils.tablePredicate(Arrays.asList(condition.f_285609_), predicate)) return false;
        return true;
    }

    public static boolean tablePredicate(List<LootItemCondition> conditions, ILootTableIdConditionPredicate predicate) {
        return conditions.stream().anyMatch(c -> GlobalLootModifierUtils.tablePredicate(c, predicate));
    }

    public static boolean tablePredicate(List<LootItemCondition> conditions, ResourceLocation location, ILootTableIdConditionPredicate predicate) {
        return conditions.stream().anyMatch(c -> {
            if (predicate.isLootTableIdCondition((LootItemCondition)c) && predicate.getTargetLootTableId((LootItemCondition)c).equals((Object)location)) {
                return true;
            }
            if (!(c instanceof AnyOfCondition)) return false;
            AnyOfCondition condition = (AnyOfCondition)c;
            if (!GlobalLootModifierUtils.tablePredicate(Arrays.asList(condition.f_285609_), location, predicate)) return false;
            return true;
        });
    }

    public static <T extends BaseAccessor<?>> void registerGlobalLootModifier(IGlobalLootModifierPlugin.IRegistry registry, Class<T> clazz, ILootTableIdConditionPredicate predicate) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> functionClass = Class.forName(classAnnotation.value());
                registry.registerGlobalLootModifier(functionClass, (u, c) -> ((IGlobalLootModifierAccessor)ReflectionUtils.copyClassData(clazz, c)).getLootModifier((IServerUtils)u, predicate));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register GLM for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for GLM " + clazz.getName());
        }
    }

    public static Optional<ILootModifier<?>> getMissingGlobalLootModifier(IServerUtils utils, IGlobalLootModifierWrapper modifier, ILootTableIdConditionPredicate predicate) {
        if (modifier.isLootModifier()) {
            return GlobalLootModifierUtils.getLootModifier(modifier.getConditions(), conditions -> {
                ArrayTooltipNode.Builder tooltip = ArrayTooltipNode.array();
                IKeyTooltipNode fieldsTooltip = utils.getValueTooltip(utils, modifier.getName());
                TooltipUtils.addObjectFields(utils, fieldsTooltip, modifier, modifier.getLootModifierClass());
                tooltip.add(fieldsTooltip.build("ali.util.advanced_loot_info.auto_detected"));
                tooltip.add(GenericTooltipUtils.getConditionsTooltip(utils, conditions));
                return List.of(new IOperation.AddOperation(i -> true, new GlobalLootModifierNode(utils, tooltip.build())));
            }, predicate);
        }
        return Optional.empty();
    }
}

