/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class ItemNode
implements IDataNode,
IItemNode {
    public static final ResourceLocation ID = new ResourceLocation("ali", "item");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ITooltipNode tooltip;
    private final List<LootItemCondition> conditions;
    private final List<LootItemFunction> functions;
    private final Either<ItemStack, TagKey<? extends ItemLike>> item;
    private final RangeValue count;
    private final float chance;

    public ItemNode(float chance, RangeValue count, ItemStack item, ITooltipNode tooltip, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this(chance, count, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)item), tooltip, functions, conditions);
    }

    public ItemNode(float chance, RangeValue count, TagKey<? extends ItemLike> tag, ITooltipNode tooltip, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this(chance, count, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.right(tag), tooltip, functions, conditions);
    }

    public ItemNode(float chance, RangeValue count, Either<ItemStack, TagKey<? extends ItemLike>> item, ITooltipNode tooltip, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this.chance = chance;
        this.count = count;
        this.item = item;
        this.tooltip = tooltip;
        this.functions = functions;
        this.conditions = conditions;
    }

    public ItemNode(IClientUtils utils, FriendlyByteBuf buf) {
        this.item = buf.m_236862_(FriendlyByteBuf::m_130267_, b -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)b.m_130281_()));
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.count = new RangeValue(buf);
        this.chance = buf.readFloat();
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
    }

    @Override
    public Either<ItemStack, TagKey<? extends ItemLike>> getModifiedItem() {
        return this.item;
    }

    @Override
    public List<LootItemCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<LootItemFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, FriendlyByteBuf buf) {
        int index = buf.writerIndex();
        try {
            buf.m_236810_(this.item, FriendlyByteBuf::m_130055_, (b, t) -> b.m_130085_(t.f_203868_()));
        }
        catch (Throwable e) {
            buf.writerIndex(index);
            buf.m_236810_(Either.left((Object)ItemStack.f_41583_), FriendlyByteBuf::m_130055_, (b, t) -> {});
            LOGGER.warn("Failed to encode {}/{}", new Object[]{BuiltInRegistries.f_257033_.m_7981_((Object)this.item.left().map(ItemStack::m_41720_).orElse(Items.f_41852_)), this.item.right().orElse(null), e});
        }
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        this.count.encode(buf);
        buf.writeFloat(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

