/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.nodes.AlternativesNode;
import com.yanny.ali.plugin.common.nodes.DynamicNode;
import com.yanny.ali.plugin.common.nodes.EmptyNode;
import com.yanny.ali.plugin.common.nodes.GroupNode;
import com.yanny.ali.plugin.common.nodes.ItemNode;
import com.yanny.ali.plugin.common.nodes.LootPoolNode;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.nodes.ReferenceNode;
import com.yanny.ali.plugin.common.nodes.SequenceNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.SequentialEntry;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class NodeUtils {
    @NotNull
    public static ItemNode getItemNode(IServerUtils utils, LootItem entry, float rawChance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        return NodeUtils.getItemNode(utils, (LootPoolSingletonContainer)entry, f -> Either.left((Object)TooltipUtils.getItemStack(utils, entry.f_79564_.m_7968_(), f)), rawChance, sumWeight, functions, conditions);
    }

    @NotNull
    public static ItemNode getTagNode(IServerUtils utils, TagEntry entry, float rawChance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        return NodeUtils.getItemNode(utils, (LootPoolSingletonContainer)entry, f -> Either.right((Object)entry.f_79821_), rawChance, sumWeight, functions, conditions);
    }

    @NotNull
    public static ItemNode getItemNode(IServerUtils utils, LootPoolSingletonContainer entry, Function<List<LootItemFunction>, Either<ItemStack, TagKey<? extends ItemLike>>> itemGetter, float rawChance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemCondition> allConditions = NodeUtils.getAllConditions((LootPoolEntryContainer)entry, conditions);
        List<LootItemFunction> allFunctions = NodeUtils.getAllFunctions(entry, functions);
        float chance = NodeUtils.getChance(entry, rawChance, sumWeight);
        RangeValue count = NodeUtils.getEnchantedCount(utils, allFunctions).get(null).get(0);
        Map<Enchantment, Map<Integer, RangeValue>> enchantedChance = NodeUtils.getEnchantedChance(utils, allConditions, chance);
        Map<Enchantment, Map<Integer, RangeValue>> enchantedCount = NodeUtils.getEnchantedCount(utils, allFunctions);
        ITooltipNode tooltip = EntryTooltipUtils.getTooltip(utils, entry.f_79676_, enchantedChance, enchantedCount, allFunctions, allConditions);
        return new ItemNode(chance, count, itemGetter.apply(allFunctions), tooltip, allFunctions, allConditions);
    }

    @NotNull
    public static AlternativesNode getAlternativesNode(IServerUtils utils, AlternativesEntry entry, float rawChance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemCondition> allConditions = NodeUtils.getAllConditions((LootPoolEntryContainer)entry, conditions);
        List<IDataNode> children = NodeUtils.getChildren(utils, entry.f_79428_, rawChance, sumWeight, functions, allConditions);
        ITooltipNode tooltip = EntryTooltipUtils.getAlternativesTooltip();
        return new AlternativesNode(children, tooltip);
    }

    @NotNull
    public static DynamicNode getDynamicNode(IServerUtils utils, DynamicLoot entry, float rawChance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = NodeUtils.getAllFunctions((LootPoolSingletonContainer)entry, functions);
        List<LootItemCondition> allConditions = NodeUtils.getAllConditions((LootPoolEntryContainer)entry, conditions);
        float chance = NodeUtils.getChance((LootPoolSingletonContainer)entry, rawChance, sumWeight);
        ITooltipNode tooltip = EntryTooltipUtils.getDynamicTooltip(utils, entry.f_79676_, chance, allFunctions, allConditions);
        return new DynamicNode(chance, tooltip);
    }

    @NotNull
    public static EmptyNode getEmptyNode(IServerUtils utils, EmptyLootItem entry, float rawChance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = NodeUtils.getAllFunctions((LootPoolSingletonContainer)entry, functions);
        List<LootItemCondition> allConditions = NodeUtils.getAllConditions((LootPoolEntryContainer)entry, conditions);
        float chance = NodeUtils.getChance((LootPoolSingletonContainer)entry, rawChance, sumWeight);
        Map<Enchantment, Map<Integer, RangeValue>> enchantedChance = NodeUtils.getEnchantedChance(utils, allConditions, chance);
        ITooltipNode tooltip = EntryTooltipUtils.getEmptyTooltip(utils, entry.f_79676_, enchantedChance, allFunctions, allConditions);
        return new EmptyNode(chance, tooltip);
    }

    @NotNull
    public static GroupNode getGroupNode(IServerUtils utils, EntryGroup entry, float rawChance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemCondition> allConditions = NodeUtils.getAllConditions((LootPoolEntryContainer)entry, conditions);
        List<IDataNode> children = NodeUtils.getChildren(utils, entry.f_79428_, rawChance, sumWeight, functions, allConditions);
        ITooltipNode tooltip = EntryTooltipUtils.getGroupTooltip();
        return new GroupNode(children, tooltip);
    }

    @NotNull
    public static SequenceNode getSequenceNode(IServerUtils utils, SequentialEntry entry, float rawChance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemCondition> allConditions = NodeUtils.getAllConditions((LootPoolEntryContainer)entry, conditions);
        List<IDataNode> children = NodeUtils.getChildren(utils, entry.f_79428_, rawChance, sumWeight, functions, allConditions);
        ITooltipNode tooltip = EntryTooltipUtils.getSequentialTooltip();
        return new SequenceNode(children, tooltip);
    }

    @NotNull
    public static ReferenceNode getReferenceNode(IServerUtils utils, LootTableReference entry, float rawChance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = NodeUtils.getAllFunctions((LootPoolSingletonContainer)entry, functions);
        List<LootItemCondition> allConditions = NodeUtils.getAllConditions((LootPoolEntryContainer)entry, conditions);
        float chance = NodeUtils.getChance((LootPoolSingletonContainer)entry, rawChance, sumWeight);
        LootTable lootTable = utils.getLootTable(entry.f_79754_);
        ITooltipNode tooltip = EntryTooltipUtils.getReferenceTooltip(entry, rawChance, sumWeight);
        List<IDataNode> children = lootTable != null ? Collections.singletonList(NodeUtils.getLootTableNode(Collections.emptyList(), utils, lootTable, chance, allFunctions, allConditions)) : Collections.singletonList(new MissingNode(utils.getValueTooltip(utils, entry.f_79754_).build("ali.property.value.loot_table")));
        return new ReferenceNode(children, chance, tooltip);
    }

    @NotNull
    public static ReferenceNode getReferenceNode(IServerUtils utils, ResourceLocation table, List<LootItemCondition> conditions, ITooltipNode tooltip) {
        LootTable lootTable = utils.getLootTable(table);
        List<IDataNode> children = lootTable != null ? Collections.singletonList(NodeUtils.getLootTableNode(Collections.emptyList(), utils, lootTable, 1.0f, Collections.emptyList(), conditions)) : Collections.singletonList(new MissingNode(utils.getValueTooltip(utils, table).build("ali.property.value.loot_table")));
        return new ReferenceNode(children, 1.0f, tooltip);
    }

    @NotNull
    public static LootPoolNode getLootPoolNode(IServerUtils utils, LootPool entry, float rawChance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), Arrays.stream(entry.f_79026_)).toList();
        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), Arrays.stream(entry.f_79024_)).toList();
        int sumWeight = NodeUtils.getTotalWeight(Arrays.asList(entry.f_79023_));
        ITooltipNode tooltip = EntryTooltipUtils.getLootPoolTooltip(utils.convertNumber(utils, entry.f_79028_), utils.convertNumber(utils, entry.f_79029_));
        List<IDataNode> children = NodeUtils.getChildren(utils, entry.f_79023_, rawChance, sumWeight, allFunctions, allConditions);
        return new LootPoolNode(children, tooltip);
    }

    @NotNull
    public static LootTableNode getLootTableNode(List<ILootModifier<?>> modifiers) {
        ITooltipNode tooltip = EntryTooltipUtils.getLootTableTooltip();
        ArrayList<IDataNode> children = new ArrayList<IDataNode>();
        LootTableNode node = new LootTableNode(children, tooltip);
        for (ILootModifier<?> modifier : modifiers) {
            NodeUtils.processLootModifier(modifier, node);
        }
        return node;
    }

    @NotNull
    public static LootTableNode getLootTableNode(List<ILootModifier<?>> modifiers, IServerUtils utils, LootTable entry, float rawChance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), Arrays.stream(entry.f_79110_)).toList();
        ITooltipNode tooltip = EntryTooltipUtils.getLootTableTooltip();
        List<IDataNode> children = utils.getLootPools(entry).stream().map(lootPool -> NodeUtils.getLootPoolNode(utils, lootPool, rawChance, allFunctions, conditions)).toList();
        LootTableNode node = new LootTableNode(children, tooltip);
        for (ILootModifier<?> modifier : modifiers) {
            NodeUtils.processLootModifier(modifier, node);
        }
        return node;
    }

    public static float getChance(LootPoolSingletonContainer entry, float rawChance, int sumWeight) {
        return rawChance * (float)entry.f_79675_ / (float)sumWeight;
    }

    public static @Unmodifiable @NotNull List<LootItemCondition> getAllConditions(LootPoolEntryContainer entry, List<LootItemCondition> conditions) {
        return Stream.concat(conditions.stream(), Arrays.stream(entry.f_79636_)).toList();
    }

    public static @Unmodifiable @NotNull List<LootItemFunction> getAllFunctions(LootPoolSingletonContainer entry, List<LootItemFunction> functions) {
        return Stream.concat(functions.stream(), Arrays.stream(entry.f_79677_)).toList();
    }

    @NotNull
    public static List<IDataNode> getChildren(IServerUtils utils, LootPoolEntryContainer[] children, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        return Arrays.stream(children).map(c -> utils.getEntryFactory(utils, c).create(utils, (LootPoolEntryContainer)c, chance, sumWeight, functions, conditions)).toList();
    }

    @NotNull
    public static Map<Enchantment, Map<Integer, RangeValue>> getEnchantedChance(IServerUtils utils, List<LootItemCondition> conditions, float rawChance) {
        LinkedHashMap<Enchantment, Map<Integer, RangeValue>> chance = new LinkedHashMap<Enchantment, Map<Integer, RangeValue>>();
        chance.put(null, Map.of(0, new RangeValue(rawChance * 100.0f)));
        for (LootItemCondition condition : conditions) {
            utils.applyChanceModifier(utils, condition, chance);
        }
        return chance;
    }

    @NotNull
    public static Map<Enchantment, Map<Integer, RangeValue>> getEnchantedCount(IServerUtils utils, List<LootItemFunction> functions) {
        LinkedHashMap<Enchantment, Map<Integer, RangeValue>> count = new LinkedHashMap<Enchantment, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue()));
        for (LootItemFunction function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    public static int getTotalWeight(List<LootPoolEntryContainer> entries) {
        int sum = 0;
        for (LootPoolEntryContainer entry : entries) {
            if (entry instanceof LootPoolSingletonContainer) {
                LootPoolSingletonContainer singletonContainer = (LootPoolSingletonContainer)entry;
                sum += singletonContainer.f_79675_;
                continue;
            }
            if (!(entry instanceof CompositeEntryBase)) continue;
            CompositeEntryBase compositeEntryBase = (CompositeEntryBase)entry;
            if (entry instanceof AlternativesEntry) {
                ++sum;
                continue;
            }
            sum += NodeUtils.getTotalWeight(Arrays.asList(compositeEntryBase.f_79428_));
        }
        return sum;
    }

    @NotNull
    public static List<Component> toComponents(List<ITooltipNode> tooltip, int pad, boolean showAdvancedTooltip) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (ITooltipNode node : tooltip) {
            components.addAll(NodeUtils.toComponents(node, pad, showAdvancedTooltip));
        }
        return components;
    }

    @NotNull
    public static List<Component> toComponents(ITooltipNode tooltip, int pad, boolean showAdvancedTooltip) {
        return tooltip.getComponents(pad, showAdvancedTooltip);
    }

    public static void processLootModifier(ILootModifier<?> modifier, LootTableNode node) {
        List<IOperation> operations = modifier.getOperations();
        for (IOperation operation : operations) {
            if (operation instanceof IOperation.AddOperation) {
                IOperation.AddOperation addOperation = (IOperation.AddOperation)operation;
                node.addChildren(addOperation.node());
                continue;
            }
            if (operation instanceof IOperation.RemoveOperation) {
                IOperation.RemoveOperation removeOperation = (IOperation.RemoveOperation)operation;
                NodeUtils.removeItem(node, removeOperation.predicate());
                continue;
            }
            if (!(operation instanceof IOperation.ReplaceOperation)) continue;
            IOperation.ReplaceOperation replaceOperation = (IOperation.ReplaceOperation)operation;
            NodeUtils.replaceItem(node, replaceOperation.factory(), replaceOperation.predicate());
        }
    }

    private static void removeItem(IDataNode node, Predicate<ItemStack> predicate) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            listNode.nodes().removeIf(n -> {
                if (n instanceof IItemNode) {
                    IItemNode itemNode = (IItemNode)((Object)n);
                    return NodeUtils.predicateEither(itemNode, predicate);
                }
                NodeUtils.removeItem(n, predicate);
                return false;
            });
            NodeUtils.removeEmptyNodes(node);
        }
    }

    private static void replaceItem(IDataNode node, Function<IDataNode, List<IDataNode>> factory, Predicate<ItemStack> predicate) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            ArrayList nodes = new ArrayList();
            listNode.nodes().replaceAll(n -> {
                IItemNode itemNode;
                if (n instanceof IItemNode && NodeUtils.predicateEither(itemNode = (IItemNode)((Object)n), predicate)) {
                    List result = (List)factory.apply((IDataNode)n);
                    if (result.size() > 1) {
                        nodes.addAll(result.subList(1, result.size()));
                    }
                    return (IDataNode)result.get(0);
                }
                if (n instanceof ListNode) {
                    ListNode l = (ListNode)n;
                    NodeUtils.replaceItem(l, factory, predicate);
                }
                return n;
            });
            nodes.forEach(listNode::addChildren);
        }
    }

    private static boolean hasItems(IDataNode node) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            return listNode.nodes().stream().anyMatch(NodeUtils::hasItems);
        }
        return node instanceof IItemNode;
    }

    private static void removeEmptyNodes(IDataNode node) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            listNode.nodes().removeIf(n -> !NodeUtils.hasItems(n));
        }
    }

    private static <T extends ItemLike> boolean predicateEither(IItemNode itemNode, Predicate<ItemStack> predicate) {
        return (Boolean)itemNode.getModifiedItem().map(predicate::test, tagKey -> {
            Registry registry = (Registry)BuiltInRegistries.f_257047_.m_7745_(tagKey.f_203867_().m_135782_());
            if (registry != null) {
                return registry.m_203431_(tagKey).map(holders -> holders.m_203614_().map(Holder::m_203334_)).orElse(Stream.of(new ItemLike[0])).map(i -> i.m_5456_().m_7968_()).allMatch(predicate);
            }
            return false;
        });
    }
}

