/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.client.widget.TextureWidget;
import com.yanny.ali.plugin.common.NodeUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WidgetUtils {
    public static final ResourceLocation TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int GROUP_WIDGET_WIDTH = 7;
    private static final int GROUP_WIDGET_HEIGHT = 18;

    @NotNull
    public static IWidget getAllWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 0, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getRandomWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 7, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getSequentialWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 14, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getAlternativesWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 21, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getDynamicWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 7, 18, rect), 28, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getUnknownWidget(RelativeRect rect) {
        return new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 18, 18, rect), 30, 0);
    }

    @NotNull
    public static IWidget getMissingWidget(RelativeRect rect) {
        return new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 18, 18, rect), 48, 0);
    }

    @NotNull
    public static IWidget getEmptyWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 18, 18, rect), 66, 0);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getArrowWidget(RelativeRect rect, IDataNode node) {
        TextureWidget widget = new TextureWidget(TEXTURE_LOC, new RelativeRect(0, 0, 24, 18, rect), 53, 18);
        widget.tooltipText(node.getTooltip());
        return widget;
    }

    @NotNull
    public static IWidget getLevelWidget(RelativeRect rect, IDataNode node, int level) {
        final RelativeRect r = new RelativeRect(0, 0, 18, 18, rect);
        final List<Component> components = NodeUtils.toComponents(node.getTooltip(), 0, Minecraft.m_91087_().f_91066_.f_92125_);
        final String txt = Integer.toString(level);
        final int txtWidth = Minecraft.m_91087_().f_91062_.m_92895_(txt);
        return new IWidget(){

            @Override
            public RelativeRect getRect() {
                return r;
            }

            @Override
            public WidgetDirection getDirection() {
                return WidgetDirection.VERTICAL;
            }

            @Override
            public List<Component> getTooltipComponents(int mouseX, int mouseY) {
                return components;
            }

            @Override
            public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
                guiGraphics.m_280195_(TEXTURE_LOC, r.getX(), r.getY(), r.getWidth(), r.getHeight(), 2, 2, 2, 2, 18, 18, 35, 18);
                guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, txt, r.getX() + (r.getWidth() - txtWidth) / 2, r.getY() + 9, 0, false);
            }
        };
    }
}

