/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.LootDataChunkMessage;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import com.yanny.ali.plugin.server.ItemCollectorUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public abstract class AbstractServer {
    private static final int MAX_CHUNK_SIZE = 32768;
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("#0.00");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<LootDataChunkMessage> chunks = new ArrayList<LootDataChunkMessage>();

    public final void readLootTables(LootDataManager manager, ServerLevel level) {
        LOGGER.info("Started reading loot info");
        long startTime = System.currentTimeMillis();
        AliConfig config = PluginManager.COMMON_REGISTRY.getConfiguration();
        AliServerRegistry serverRegistry = PluginManager.SERVER_REGISTRY;
        Map<ResourceLocation, LootTable> lootTables = AbstractServer.collectLootTables(manager);
        Map<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        HashMap<ResourceLocation, LootTable> unprocessedLootTables = new HashMap<ResourceLocation, LootTable>(lootTables);
        List<ILootModifier<?>> lootModifiers = serverRegistry.getLootModifiers();
        Map<ILootModifier.IType, List<ILootModifier>> groupedTypes = lootModifiers.stream().collect(Collectors.groupingBy(ILootModifier::getType));
        List<ILootModifier<?>> blockLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.BLOCK, Collections.emptyList());
        List<ILootModifier<?>> entityLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.ENTITY, Collections.emptyList());
        List<ILootModifier<?>> lootTableLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.LOOT_TABLE, Collections.emptyList());
        HashMap<ResourceLocation, Pair<List<Item>, List<Item>>> tradeItems = new HashMap<ResourceLocation, Pair<List<Item>, List<Item>>>();
        Pair<List<Item>, List<Item>> wanderingTraderItems = ItemCollectorUtils.collectTradeItems(serverRegistry, (Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.f_35628_);
        IDataNode wanderingTraderNode = AbstractServer.processWanderingTrader(serverRegistry);
        serverRegistry.setServerLevel(level);
        lootTables.forEach(serverRegistry::addLootTable);
        Map<ResourceLocation, List<Item>> lootTableItems = lootTables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, AbstractServer::getItems));
        this.chunks.clear();
        lootNodes.putAll(AbstractServer.processBlocks(serverRegistry, config, unprocessedLootTables, blockLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processEntities(serverRegistry, config, level, unprocessedLootTables, entityLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processLootTables(serverRegistry, config, unprocessedLootTables, lootTableLootModifiers, lootTableItems));
        Map<ResourceLocation, List<ItemStack>> lootTableItemStacks = lootNodes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AbstractServer.collectItems((IDataNode)e.getValue())));
        lootNodes = AbstractServer.removeEmptyLootTable(serverRegistry, lootNodes, lootTableItemStacks);
        HashMap<ResourceLocation, IDataNode> tradeNodes = new HashMap<ResourceLocation, IDataNode>(AbstractServer.processTrades(serverRegistry, config, tradeItems));
        LOGGER.info("Processing {} loot tables and {} trades took {}ms", new Object[]{lootNodes.size(), tradeNodes.size() + 1, System.currentTimeMillis() - startTime});
        ByteBuf rawBuf = Unpooled.buffer();
        FriendlyByteBuf buf = new FriendlyByteBuf(rawBuf);
        this.writeLootData(buf, lootTableItemStacks, lootNodes);
        this.writeTradeData(buf, tradeNodes, tradeItems, wanderingTraderNode, wanderingTraderItems);
        this.compressAndStoreData(rawBuf);
        serverRegistry.clearLootTables();
        serverRegistry.printRuntimeInfo();
    }

    public final void syncLootTables(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LOGGER.info("Started syncing loot info to {}", (Object)player.m_6302_());
            this.sendClearMessage(serverPlayer, new ClearMessage(this.chunks.size()));
            for (LootDataChunkMessage message : this.chunks) {
                try {
                    this.sendSyncLootTableMessage(serverPlayer, message);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to send message with error: {}", (Object)e.getMessage());
                }
            }
            this.sendDoneMessage(serverPlayer, new DoneMessage());
            LOGGER.info("Finished syncing loot info to {}", (Object)player.m_6302_());
        }
    }

    protected abstract void sendClearMessage(ServerPlayer var1, ClearMessage var2);

    protected abstract void sendSyncLootTableMessage(ServerPlayer var1, LootDataChunkMessage var2);

    protected abstract void sendDoneMessage(ServerPlayer var1, DoneMessage var2);

    @NotNull
    private static List<Item> getItems(Map.Entry<ResourceLocation, LootTable> lootTableMap) {
        return ItemCollectorUtils.collectLootTable(PluginManager.SERVER_REGISTRY, lootTableMap.getValue());
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> removeEmptyLootTable(AliServerRegistry serverRegistry, Map<ResourceLocation, IDataNode> lootNodes, Map<ResourceLocation, List<ItemStack>> items) {
        HashMap<ResourceLocation, IDataNode> result = new HashMap<ResourceLocation, IDataNode>();
        int emptyLootTables = 0;
        int injectedLootTables = 0;
        for (Map.Entry<ResourceLocation, IDataNode> entry : lootNodes.entrySet()) {
            IDataNode node = entry.getValue();
            if (node instanceof ListNode) {
                ListNode listNode = (ListNode)node;
                listNode.optimizeList();
            }
            if (!items.getOrDefault(entry.getKey(), Collections.emptyList()).isEmpty()) {
                if (!serverRegistry.isSubTable(entry.getKey())) {
                    result.put(entry.getKey(), node);
                    continue;
                }
                ++injectedLootTables;
                continue;
            }
            ++emptyLootTables;
        }
        LOGGER.info("Skipped {} empty or hidden loot tables and {} injected loot tables", (Object)emptyLootTables, (Object)injectedLootTables);
        return result;
    }

    @NotNull
    private static Map<ResourceLocation, LootTable> collectLootTables(LootDataManager manager) {
        HashMap<ResourceLocation, LootTable> lootTables = new HashMap<ResourceLocation, LootTable>();
        manager.m_278706_(LootDataType.f_278413_).forEach(location -> lootTables.put((ResourceLocation)location, manager.m_278676_(location)));
        return lootTables;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processBlocks(AliServerRegistry serverRegistry, AliConfig config, Map<ResourceLocation, LootTable> lootTables, List<ILootModifier<?>> blockLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<ResourceLocation, List<Item>> lootTableItems) {
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        for (Block block : BuiltInRegistries.f_256975_) {
            ResourceLocation location = block.m_60589_();
            if (location == null) continue;
            LootTable lootTable = lootTables.remove(location);
            serverRegistry.setCurrentLootTable(location);
            if (config.blockCategories.stream().filter(f -> f.validate(block)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) {
                List items = lootTableItems.getOrDefault(location, Collections.emptyList());
                List<ILootModifier<?>> lootModifiers = Stream.concat(blockLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, block, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                try {
                    if (lootTable != null) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                    } else if (!lootModifiers.isEmpty()) {
                        lootNodes.put(location, serverRegistry.parseTable(lootModifiers));
                    } else {
                        LOGGER.debug("Missing block loot table for {}", (Object)block);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to parse block loot table {} with error {}", (Object)location, (Object)e.getMessage());
                }
            }
            serverRegistry.setCurrentLootTable(null);
        }
        return lootNodes;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processEntities(AliServerRegistry serverRegistry, AliConfig config, ServerLevel level, Map<ResourceLocation, LootTable> lootTables, List<ILootModifier<?>> entityLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<ResourceLocation, List<Item>> lootTableItems) {
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        for (EntityType entityType : BuiltInRegistries.f_256780_) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)BuiltInRegistries.f_256780_.m_7981_((Object)entityType)))) {
                lootTables.remove(entityType.m_20677_());
                continue;
            }
            List<Entity> entityList = serverRegistry.createEntities(entityType, (Level)level);
            for (Entity entity : entityList) {
                Mob mob;
                ResourceLocation location;
                if (!(entity instanceof Mob) || (location = (mob = (Mob)entity).m_5743_()) == null) continue;
                LootTable lootTable = lootTables.remove(location);
                serverRegistry.setCurrentLootTable(location);
                if (config.entityCategories.stream().filter(f -> f.validate(entityType)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) {
                    List items = lootTableItems.getOrDefault(location, Collections.emptyList());
                    List<ILootModifier<?>> lootModifiers = Stream.concat(entityLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, entity, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                    try {
                        if (lootTable != null) {
                            lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                        } else if (!lootModifiers.isEmpty()) {
                            lootNodes.put(location, serverRegistry.parseTable(lootModifiers));
                        } else {
                            LOGGER.debug("Missing entity loot table for {}", (Object)entity);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        LOGGER.warn("Failed to parse entity loot table {} with error {}", (Object)location, (Object)e.getMessage());
                    }
                }
                serverRegistry.setCurrentLootTable(null);
            }
        }
        return lootNodes;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processLootTables(AliServerRegistry serverRegistry, AliConfig config, Map<ResourceLocation, LootTable> lootTables, List<ILootModifier<?>> lootTableLootModifiers, Map<ResourceLocation, List<Item>> lootTableItems) {
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        for (Map.Entry<ResourceLocation, LootTable> entry : lootTables.entrySet()) {
            ResourceLocation location = entry.getKey();
            serverRegistry.setCurrentLootTable(location);
            if (config.gameplayCategories.stream().filter(f -> f.validate(location)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) {
                LootTable lootTable = entry.getValue();
                List<Item> items = lootTableItems.get(location);
                List<ILootModifier<?>> lootModifiers = lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items)).toList();
                try {
                    lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    LOGGER.warn("Failed to parse loot table {} with error {}", (Object)location, (Object)e.getMessage());
                }
            }
            serverRegistry.setCurrentLootTable(null);
        }
        lootTables.clear();
        return lootNodes;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processTrades(AliServerRegistry serverRegistry, AliConfig config, Map<ResourceLocation, Pair<List<Item>, List<Item>>> tradeItems) {
        HashMap<ResourceLocation, IDataNode> nodes = new HashMap<ResourceLocation, IDataNode>();
        for (Map.Entry entry : BuiltInRegistries.f_256735_.m_6579_()) {
            ResourceLocation location = ((ResourceKey)entry.getKey()).m_135782_();
            serverRegistry.setCurrentLootTable(location);
            if (config.tradeCategories.stream().filter(f -> f.validate(location)).findFirst().map(f -> !f.isHidden()).orElse(false).booleanValue()) {
                Int2ObjectMap itemListingMap = (Int2ObjectMap)VillagerTrades.f_35627_.get(entry.getValue());
                if (itemListingMap != null && itemListingMap.int2ObjectEntrySet().stream().anyMatch(e -> ((VillagerTrades.ItemListing[])e.getValue()).length > 0)) {
                    try {
                        nodes.put(location, serverRegistry.parseTrade((Int2ObjectMap<VillagerTrades.ItemListing[]>)itemListingMap));
                        tradeItems.put(location, ItemCollectorUtils.collectTradeItems(serverRegistry, (Int2ObjectMap<VillagerTrades.ItemListing[]>)itemListingMap));
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                        LOGGER.warn("Failed to parse trade for villager {} with error {}", (Object)location, (Object)e2.getMessage());
                    }
                } else {
                    LOGGER.warn("No trades defined for {}", (Object)location);
                }
            }
            serverRegistry.setCurrentLootTable(null);
        }
        return nodes;
    }

    @NotNull
    private static IDataNode processWanderingTrader(AliServerRegistry serverRegistry) {
        try {
            return serverRegistry.parseTrade((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.f_35628_);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Failed to parse wandering trader with error {}", (Object)e.getMessage());
            return new MissingNode(EmptyTooltipNode.EMPTY);
        }
    }

    private static <T> boolean predicateModifier(ILootModifier<?> modifier, T value, List<Item> items) {
        return modifier.predicate(value) && AbstractServer.predicateItem(modifier, items);
    }

    private static boolean predicateItem(ILootModifier<?> modifier, List<Item> items) {
        if (!items.isEmpty()) {
            return items.stream().anyMatch(i -> modifier.getOperations().stream().anyMatch(o -> o.predicate().test(i.m_7968_())));
        }
        return true;
    }

    @NotNull
    private static List<ItemStack> collectItems(IDataNode node) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            for (IDataNode n : listNode.nodes()) {
                itemStacks.addAll(AbstractServer.collectItems(n));
            }
        } else if (node instanceof IItemNode) {
            IItemNode itemNode = (IItemNode)((Object)node);
            itemStacks.addAll((Collection)itemNode.getModifiedItem().map(List::of, AbstractServer::toItemStacks));
        }
        return itemStacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLootData(FriendlyByteBuf buf, Map<ResourceLocation, List<ItemStack>> lootTableItemStacks, Map<ResourceLocation, IDataNode> lootNodes) {
        AliServerRegistry utils = PluginManager.SERVER_REGISTRY;
        int countIndex = buf.writerIndex();
        int successfulNodes = 0;
        buf.writeInt(lootNodes.size());
        for (Map.Entry<ResourceLocation, IDataNode> nodeEntry : lootNodes.entrySet()) {
            int startOfNode = buf.writerIndex();
            try {
                utils.setCurrentLootTable(nodeEntry.getKey());
                buf.m_130085_(nodeEntry.getKey());
                nodeEntry.getValue().encode(utils, buf);
                buf.m_236828_((Collection)lootTableItemStacks.getOrDefault(nodeEntry.getKey(), Collections.emptyList()), FriendlyByteBuf::m_130055_);
                ++successfulNodes;
            }
            catch (Throwable e) {
                buf.writerIndex(startOfNode);
                LOGGER.warn("Failed to write loot data in {}", (Object)nodeEntry.getKey(), (Object)e);
            }
            finally {
                utils.setCurrentLootTable(null);
            }
        }
        if (successfulNodes != lootNodes.size()) {
            int endIndex = buf.writerIndex();
            buf.writerIndex(countIndex);
            buf.writeInt(successfulNodes);
            buf.writerIndex(endIndex);
        }
        lootNodes.clear();
        lootTableItemStacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTradeData(FriendlyByteBuf buf, Map<ResourceLocation, IDataNode> trades, Map<ResourceLocation, Pair<List<Item>, List<Item>>> items, IDataNode wanderingTraderNode, Pair<List<Item>, List<Item>> wanderingTraderItems) {
        AliServerRegistry utils = PluginManager.SERVER_REGISTRY;
        int countIndex = buf.writerIndex();
        int successfulNodes = 0;
        buf.writeInt(trades.size());
        for (Map.Entry<ResourceLocation, IDataNode> nodeEntry : trades.entrySet()) {
            int startOfNode = buf.writerIndex();
            try {
                Pair<List<Item>, List<Item>> pair = items.getOrDefault(nodeEntry.getKey(), (Pair<List<Item>, List<Item>>)new Pair(Collections.emptyList(), Collections.emptyList()));
                utils.setCurrentLootTable(nodeEntry.getKey());
                buf.m_130085_(nodeEntry.getKey());
                nodeEntry.getValue().encode(utils, buf);
                buf.m_236828_((Collection)pair.getA(), (b, i) -> b.m_130085_(BuiltInRegistries.f_257033_.m_7981_(i)));
                buf.m_236828_((Collection)pair.getB(), (b, i) -> b.m_130085_(BuiltInRegistries.f_257033_.m_7981_(i)));
                ++successfulNodes;
            }
            catch (Throwable e) {
                buf.writerIndex(startOfNode);
                LOGGER.warn("Failed to write trade data in {}", (Object)nodeEntry.getKey(), (Object)e);
            }
            finally {
                utils.setCurrentLootTable(null);
            }
        }
        if (successfulNodes != trades.size()) {
            int endIndex = buf.writerIndex();
            buf.writerIndex(countIndex);
            buf.writeInt(successfulNodes);
            buf.writerIndex(endIndex);
        }
        int wtStart = buf.writerIndex();
        try {
            utils.setCurrentLootTable(new ResourceLocation("wandering_trader"));
            wanderingTraderNode.encode(utils, buf);
            buf.m_236828_((Collection)wanderingTraderItems.getA(), (b, i) -> b.m_130085_(BuiltInRegistries.f_257033_.m_7981_(i)));
            buf.m_236828_((Collection)wanderingTraderItems.getB(), (b, i) -> b.m_130085_(BuiltInRegistries.f_257033_.m_7981_(i)));
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to encode Wandering Trader", e);
            buf.writerIndex(wtStart);
            new TradeNode(utils, (Int2ObjectMap<VillagerTrades.ItemListing[]>)new Int2ObjectOpenHashMap()).encode(utils, buf);
            buf.m_236828_(List.of(), (b, i) -> {});
            buf.m_236828_(List.of(), (b, i) -> {});
        }
        finally {
            utils.setCurrentLootTable(null);
        }
        trades.clear();
        items.clear();
    }

    private void compressAndStoreData(ByteBuf rawBuf) {
        int rawSize = rawBuf.readableBytes();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(rawSize);
        try (GZIPOutputStream gzip = new GZIPOutputStream(bos);){
            rawBuf.readBytes((OutputStream)gzip, rawBuf.readableBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        byte[] compressedData = bos.toByteArray();
        int totalChunks = (int)Math.ceil((double)compressedData.length / 32768.0);
        for (int i = 0; i < totalChunks; ++i) {
            int offset = i * 32768;
            int length = Math.min(32768, compressedData.length - offset);
            byte[] chunkData = new byte[length];
            System.arraycopy(compressedData, offset, chunkData, 0, length);
            this.chunks.add(new LootDataChunkMessage(i, chunkData));
        }
        rawBuf.release();
        LOGGER.info("Compressed loot data ({} MB -> {} MB) and stored in {} chunk(s)", new Object[]{DOUBLE_FORMAT.format((double)rawSize / 1024.0 / 1024.0), DOUBLE_FORMAT.format((double)compressedData.length / 1024.0 / 1024.0), totalChunks});
    }

    private static <T extends ItemLike> List<ItemStack> toItemStacks(TagKey<T> tag) {
        Registry registry = (Registry)BuiltInRegistries.f_257047_.m_7745_(tag.f_203867_().m_135782_());
        if (registry != null) {
            return registry.m_203431_(tag).map(holders -> holders.m_203614_().map(Holder::m_203334_).map(i -> i.m_5456_().m_7968_()).toList()).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }
}

