/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ICommonUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class AliClientRegistry
implements IClientRegistry,
IClientUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<ResourceLocation, IClientRegistry.IWidgetFactory> widgetMap = new HashMap<ResourceLocation, IClientRegistry.IWidgetFactory>();
    private final Map<ResourceLocation, IClientRegistry.DataFactory<?>> dataNodeFactoryMap = new HashMap();
    private final Map<ResourceLocation, IClientRegistry.TooltipFactory<?>> tooltipNodeFactoryMap = new HashMap();
    private final ICommonUtils utils;
    private final AtomicInteger receivedChunks = new AtomicInteger(0);
    private final AtomicInteger receivedChunksPerSecond = new AtomicInteger(0);
    private ScheduledExecutorService loggerScheduler;
    private final AtomicInteger syncedTagCount = new AtomicInteger(0);
    private final AtomicBoolean loggedIn = new AtomicBoolean(false);
    private volatile DataReceiver currentDataReceiver = null;
    private final AtomicReference<CompletableFuture<byte[]>> activeDataPromise = new AtomicReference(new CompletableFuture());

    public AliClientRegistry(ICommonUtils utils) {
        this.utils = utils;
    }

    public CompletableFuture<byte[]> getCurrentDataFuture() {
        return this.activeDataPromise.get();
    }

    public void addChunkData(int index, byte[] data) {
        DataReceiver receiver = this.currentDataReceiver;
        if (receiver == null) {
            return;
        }
        this.receivedChunks.incrementAndGet();
        this.receivedChunksPerSecond.incrementAndGet();
        receiver.messageReceived(index, data);
    }

    public synchronized void startLootData(int totalMessages) {
        this.clearLootData();
        this.currentDataReceiver = new DataReceiver(totalMessages);
        CompletableFuture<byte[]> currentPromise = this.activeDataPromise.get();
        this.currentDataReceiver.getFuture().whenComplete((data, throwable) -> {
            if (throwable != null) {
                currentPromise.completeExceptionally((Throwable)throwable);
            } else {
                currentPromise.complete((byte[])data);
            }
        });
        this.startLogging();
        LOGGER.info("Started receiving loot data");
    }

    public synchronized void clearLootData() {
        CompletableFuture oldPromise;
        if (this.currentDataReceiver != null) {
            this.currentDataReceiver.cancelOperation();
            this.currentDataReceiver = null;
            this.stopLogging(true);
        }
        if (!(oldPromise = this.activeDataPromise.getAndSet(new CompletableFuture())).isDone()) {
            oldPromise.cancel(true);
        }
        LOGGER.info("Cleared Loot data");
    }

    public synchronized void reloadLootData() {
        if (this.loggedIn.get() && this.syncedTagCount.getAndIncrement() > 0) {
            LOGGER.info("Reloading loot data");
            this.clearLootData();
        }
    }

    public synchronized void loggingIn() {
        LOGGER.info("Player login received");
        this.loggedIn.set(true);
    }

    public synchronized void loggingOut() {
        LOGGER.info("Player logout received");
        this.clearLootData();
        this.loggedIn.set(false);
        this.syncedTagCount.set(0);
    }

    public synchronized void doneLootData() {
        DataReceiver receiver = this.currentDataReceiver;
        if (receiver == null) {
            return;
        }
        receiver.forceDone();
        this.stopLogging(false);
        LOGGER.info("Finished receiving loot data");
    }

    @Override
    public void registerWidget(ResourceLocation id, IClientRegistry.IWidgetFactory factory) {
        this.widgetMap.put(id, factory);
    }

    @Override
    public <T extends IDataNode> void registerDataNode(ResourceLocation id, IClientRegistry.DataFactory<T> dataFactory) {
        this.dataNodeFactoryMap.put(id, dataFactory);
    }

    @Override
    public <T extends ITooltipNode> void registerTooltipNode(ResourceLocation id, IClientRegistry.TooltipFactory<T> tooltipFactory) {
        this.tooltipNodeFactoryMap.put(id, tooltipFactory);
    }

    @Override
    public List<IWidget> createWidgets(IWidgetUtils utils, List<IDataNode> entries, RelativeRect parent, int maxWidth) {
        int posX = 0;
        int posY = 0;
        ArrayList<IWidget> widgets = new ArrayList<IWidget>(entries.size());
        WidgetDirection lastDirection = null;
        for (IDataNode entry : entries) {
            IClientRegistry.IWidgetFactory widgetFactory = this.widgetMap.getOrDefault(entry.getId(), this.widgetMap.get(MissingNode.ID));
            IWidget widget = widgetFactory.create(utils, entry, new RelativeRect(posX, posY, parent.getWidth() - posX, 0, parent), maxWidth);
            RelativeRect bounds = widget.getRect();
            WidgetDirection direction = widget.getDirection();
            if (lastDirection == null) {
                if (direction == WidgetDirection.HORIZONTAL) {
                    posX += bounds.getWidth();
                } else {
                    posY += bounds.getHeight() + 2;
                }
            } else if (lastDirection == WidgetDirection.HORIZONTAL && direction == WidgetDirection.HORIZONTAL) {
                if (bounds.getRight() <= maxWidth) {
                    posX += bounds.getWidth();
                } else {
                    posX = bounds.getWidth();
                    bounds.setOffset(0, posY += ((IWidget)widgets.get(widgets.size() - 1)).getRect().getHeight());
                }
            } else {
                posX = 0;
                if (direction != lastDirection) {
                    if (lastDirection == WidgetDirection.HORIZONTAL) {
                        posY += ((IWidget)widgets.get(widgets.size() - 1)).getRect().getHeight() + 2;
                    }
                    bounds.setOffset(posX, posY);
                    widget.onResize(bounds, maxWidth);
                }
                if (direction != WidgetDirection.HORIZONTAL) {
                    posY += bounds.getHeight() + 2;
                } else {
                    posX += bounds.getWidth();
                }
            }
            widgets.add(widget);
            lastDirection = direction;
        }
        int w = 0;
        int h = 0;
        for (IWidget widget : widgets) {
            RelativeRect rect = widget.getRect();
            w = Math.max(w, rect.getOffsetX() + rect.getWidth());
            h = Math.max(h, rect.getOffsetY() + rect.getHeight());
        }
        parent.setDimensions(w, h);
        return widgets;
    }

    @Override
    public <T extends IDataNode> IClientRegistry.DataFactory<T> getDataNodeFactory(ResourceLocation id) {
        IClientRegistry.DataFactory<?> dataFactory = this.dataNodeFactoryMap.get(id);
        return Objects.requireNonNullElseGet(dataFactory, () -> {
            throw new IllegalStateException(String.format("Failed to construct data node - node {%s} was not registered!", id));
        });
    }

    @Override
    public <T extends ITooltipNode> IClientRegistry.TooltipFactory<T> getTooltipNodeFactory(ResourceLocation id) {
        IClientRegistry.TooltipFactory<?> tooltipFactory = this.tooltipNodeFactoryMap.get(id);
        return Objects.requireNonNullElseGet(tooltipFactory, () -> {
            throw new IllegalStateException(String.format("Failed to construct tooltip node - node {%s} was not registered!", id));
        });
    }

    @Override
    public List<Entity> createEntities(EntityType<?> type, Level level) {
        return this.utils.createEntities(type, level);
    }

    public void printRegistrationInfo() {
        LOGGER.info("Registered {} widgets", (Object)this.widgetMap.size());
        LOGGER.info("Registered {} data node factories", (Object)this.dataNodeFactoryMap.size());
        LOGGER.info("Registered {} tooltip node factories", (Object)this.tooltipNodeFactoryMap.size());
    }

    private void startLogging() {
        Runnable logTask = () -> {
            long count = this.receivedChunksPerSecond.getAndSet(0);
            LOGGER.info("Received {} chunk(s) per second", (Object)count);
        };
        this.receivedChunks.set(0);
        this.receivedChunksPerSecond.set(0);
        this.loggerScheduler = Executors.newSingleThreadScheduledExecutor();
        this.loggerScheduler.scheduleAtFixedRate(logTask, 1L, 1L, TimeUnit.SECONDS);
    }

    private void stopLogging(boolean forcedStop) {
        if (this.loggerScheduler != null) {
            long count = this.receivedChunksPerSecond.getAndSet(0);
            if (!forcedStop) {
                LOGGER.info("Received last {} chunk(s). Done receiving data.", (Object)count);
            }
            this.loggerScheduler.shutdownNow();
            try {
                if (!this.loggerScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Logging scheduler didn't stop in time!");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class DataReceiver {
        private final CompletableFuture<byte[]> dataFuture = new CompletableFuture();
        private final Map<Integer, byte[]> chunkMap = new ConcurrentHashMap<Integer, byte[]>();
        private final int totalChunks;
        private final AtomicInteger receivedChunksCount = new AtomicInteger(0);

        public DataReceiver(int expectedMessageCount) {
            this.totalChunks = expectedMessageCount;
        }

        public void messageReceived(int index, byte[] data) {
            if (this.dataFuture.isDone()) {
                return;
            }
            this.chunkMap.put(index, data);
            if (this.receivedChunksCount.incrementAndGet() == this.totalChunks) {
                this.completeFuture();
            }
        }

        public void forceDone() {
            if (!this.dataFuture.isDone()) {
                String errorMsg = String.format("Incomplete loot data! Expected %d chunks, but received only %d. Data is unusable.", this.totalChunks, this.receivedChunksCount.get());
                LOGGER.error(errorMsg);
                this.dataFuture.completeExceptionally(new IllegalStateException(errorMsg));
            }
        }

        private void completeFuture() {
            if (this.dataFuture.isDone()) {
                return;
            }
            int totalCompressedSize = this.chunkMap.values().stream().mapToInt(a -> ((byte[])a).length).sum();
            byte[] fullCompressedData = new byte[totalCompressedSize];
            int offset = 0;
            for (int i = 0; i < this.totalChunks; ++i) {
                byte[] chunk = this.chunkMap.get(i);
                System.arraycopy(chunk, 0, fullCompressedData, offset, chunk.length);
                offset += chunk.length;
            }
            this.chunkMap.clear();
            this.dataFuture.complete(fullCompressedData);
        }

        public void cancelOperation() {
            if (!this.dataFuture.isDone()) {
                this.dataFuture.cancel(true);
            }
            this.chunkMap.clear();
        }

        public CompletableFuture<byte[]> getFuture() {
            return this.dataFuture;
        }
    }
}

