/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.lootjs.node;

import com.almostreliable.lootjs.core.ILootHandler;
import com.almostreliable.lootjs.loot.action.AddLootAction;
import com.almostreliable.lootjs.loot.action.GroupedLootAction;
import com.almostreliable.lootjs.loot.action.WeightedAddLootAction;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.lootjs.mixin.MixinCompositeLootAction;
import com.yanny.ali.lootjs.mixin.MixinGroupedLootAction;
import com.yanny.ali.lootjs.node.AddLootNode;
import com.yanny.ali.lootjs.node.WeightedAddLootNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class GroupLootNode
extends ListNode {
    public static final ResourceLocation ID = new ResourceLocation("lootjs", "grouped_loot");
    private final ITooltipNode tooltip;

    public GroupLootNode(IServerUtils utils, GroupedLootAction lootPool, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        MixinGroupedLootAction action = (MixinGroupedLootAction)lootPool;
        this.tooltip = EntryTooltipUtils.getLootPoolTooltip(utils.convertNumber(utils, action.getNumberProvider()), new RangeValue(0.0f));
        for (ILootHandler entry : ((MixinCompositeLootAction)lootPool).getHandlers()) {
            if (entry instanceof AddLootAction) {
                AddLootAction addLootAction = (AddLootAction)entry;
                this.addChildren(new AddLootNode(utils, addLootAction, functions, conditions));
                continue;
            }
            if (!(entry instanceof WeightedAddLootAction)) continue;
            WeightedAddLootAction weightedAddLootNode = (WeightedAddLootAction)entry;
            this.addChildren(new WeightedAddLootNode(utils, weightedAddLootNode, functions, conditions));
        }
    }

    public GroupLootNode(IClientUtils utils, FriendlyByteBuf buf) {
        super(utils, buf);
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
    }

    @Override
    public void encodeNode(IServerUtils utils, FriendlyByteBuf buf) {
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

