/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.forge.plugin.mods.farmers_delight;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.forge.plugin.GlobalLootModifier;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.common.nodes.ItemNode;
import com.yanny.ali.plugin.common.nodes.ModifiedNode;
import com.yanny.ali.plugin.glm.GlobalLootModifierUtils;
import com.yanny.ali.plugin.glm.IGlobalLootModifierAccessor;
import com.yanny.ali.plugin.glm.ILootTableIdConditionPredicate;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.FieldAccessor;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;

@ClassAccessor(value="vectorwing.farmersdelight.common.loot.modifier.ReplaceItemModifier")
public class ReplaceItemModifier
extends GlobalLootModifier
implements IGlobalLootModifierAccessor {
    @FieldAccessor
    private Item removedItem;
    @FieldAccessor
    private Item addedItem;
    @FieldAccessor
    private int addedCount;

    public ReplaceItemModifier(LootModifier parent) {
        super(parent);
    }

    @Override
    public Optional<ILootModifier<?>> getLootModifier(IServerUtils utils, ILootTableIdConditionPredicate predicate) {
        List<LootItemCondition> conditionList = Arrays.asList(this.conditions);
        return GlobalLootModifierUtils.getLootModifier(conditionList, c -> {
            Function<IDataNode, List<IDataNode>> factory = src -> {
                ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                IItemNode node = (IItemNode)((Object)src);
                List<LootItemCondition> allConditions = Stream.concat(c.stream(), node.getConditions().stream()).toList();
                Map<Enchantment, Map<Integer, RangeValue>> chance = NodeUtils.getEnchantedChance(utils, allConditions, 1.0f);
                Map<Enchantment, Map<Integer, RangeValue>> count = NodeUtils.getEnchantedCount(utils, Collections.emptyList());
                ITooltipNode tooltip = EntryTooltipUtils.getTooltip(utils, 0, chance, count, Collections.emptyList(), allConditions);
                if (!c.isEmpty()) {
                    nodes.add(new ModifiedNode(utils, (IDataNode)src, new ItemNode(1.0f, new RangeValue(this.addedCount), this.addedItem.m_7968_(), tooltip, Collections.emptyList(), allConditions)));
                } else {
                    nodes.add(new ItemNode(1.0f, new RangeValue(this.addedCount), this.addedItem.m_7968_(), tooltip, Collections.emptyList(), allConditions));
                }
                return nodes;
            };
            return Collections.singletonList(new IOperation.ReplaceOperation(itemStack -> itemStack.m_41720_().equals(this.removedItem), factory));
        }, predicate);
    }
}

