/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.forge.plugin;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.forge.mixin.MixinCanToolPerformAction;
import com.yanny.ali.forge.mixin.MixinForgeInternalHandler;
import com.yanny.ali.forge.mixin.MixinLootModifier;
import com.yanny.ali.forge.mixin.MixinLootTableIdCondition;
import com.yanny.ali.forge.plugin.IForgePlugin;
import com.yanny.ali.platform.Services;
import com.yanny.ali.plugin.glm.GlobalLootModifierUtils;
import com.yanny.ali.plugin.glm.IGlobalLootModifierPlugin;
import com.yanny.ali.plugin.glm.IGlobalLootModifierWrapper;
import com.yanny.ali.plugin.glm.ILootTableIdConditionPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@AliEntrypoint
public class ForgePlugin
implements IPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public String getModId() {
        return "forge";
    }

    @Override
    public void registerServer(IServerRegistry registry) {
        registry.registerConditionTooltip(CanToolPerformAction.class, ForgePlugin::getCanToolPerformActionTooltip);
        registry.registerConditionTooltip(LootTableIdCondition.class, ForgePlugin::getLootTableIdTooltip);
        registry.registerLootModifiers(ForgePlugin::registerLootModifiers);
    }

    @NotNull
    public static ITooltipNode getCanToolPerformActionTooltip(IServerUtils utils, CanToolPerformAction cond) {
        return utils.getValueTooltip(utils, ((MixinCanToolPerformAction)cond).getAction().name()).build("ali.type.condition.can_tool_perform_action");
    }

    @NotNull
    public static ITooltipNode getLootTableIdTooltip(IServerUtils utils, LootTableIdCondition cond) {
        return utils.getValueTooltip(utils, ((MixinLootTableIdCondition)cond).getTargetLootTableId()).build("ali.type.condition.loot_table_id");
    }

    @NotNull
    private static List<ILootModifier<?>> registerLootModifiers(IServerUtils utils) {
        HashMap glmMap = new HashMap();
        HashSet missingGLM = new HashSet();
        ArrayList lootModifiers = new ArrayList();
        ILootTableIdConditionPredicate tablePredicate = ForgePlugin.getLootTableIdConditionPredicate();
        IGlobalLootModifierPlugin.IRegistry forgeRegistry = ForgePlugin.getForgeRegistry(glmMap);
        for (IPlugin plugin : Services.getPlatform().getPlugins()) {
            if (!(plugin instanceof IForgePlugin)) continue;
            IForgePlugin forgePlugin = (IForgePlugin)plugin;
            forgePlugin.registerGlobalLootModifier(forgeRegistry, tablePredicate);
        }
        LootModifierManager lootModifierManager = MixinForgeInternalHandler.getLootModifierManager();
        for (IGlobalLootModifier globalLootModifier : lootModifierManager.getAllLootMods()) {
            IGlobalLootModifierWrapper wrapper = ForgePlugin.wrap(globalLootModifier);
            try {
                BiFunction getter = (BiFunction)glmMap.get(globalLootModifier.getClass());
                if (getter != null) {
                    Optional lootModifier = (Optional)getter.apply(utils, globalLootModifier);
                    if (lootModifier.isPresent()) {
                        lootModifiers.add((ILootModifier)lootModifier.get());
                        continue;
                    }
                    LOGGER.warn("Unable to locate destination for GLM {}", (Object)wrapper.getName());
                    continue;
                }
                Optional<ILootModifier<?>> modifier = GlobalLootModifierUtils.getMissingGlobalLootModifier(utils, wrapper, tablePredicate);
                missingGLM.add(globalLootModifier.getClass());
                if (modifier.isPresent()) {
                    lootModifiers.add(modifier.get());
                    continue;
                }
                LOGGER.warn("Unable to locate destination for auto GLM {}", (Object)wrapper.getName());
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.warn("Failed to add GLM with error {}", (Object)e.getMessage());
            }
        }
        missingGLM.forEach(c -> LOGGER.warn("Missing GLM for {}", (Object)c.getName()));
        return lootModifiers;
    }

    @NotNull
    private static ILootTableIdConditionPredicate getLootTableIdConditionPredicate() {
        return new ILootTableIdConditionPredicate(){

            @Override
            public boolean isLootTableIdCondition(LootItemCondition condition) {
                return condition instanceof LootTableIdCondition;
            }

            @Override
            public ResourceLocation getTargetLootTableId(LootItemCondition condition) {
                return ((MixinLootTableIdCondition)condition).getTargetLootTableId();
            }
        };
    }

    @NotNull
    private static IGlobalLootModifierWrapper wrap(final IGlobalLootModifier modifier) {
        return new IGlobalLootModifierWrapper(){

            @Override
            public ResourceLocation getName() {
                return ((IForgeRegistry)ForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()).getKey((Object)modifier.codec());
            }

            @Override
            public Class<?> getLootModifierClass() {
                return LootModifier.class;
            }

            @Override
            public boolean isLootModifier() {
                return modifier instanceof LootModifier;
            }

            @Override
            public List<LootItemCondition> getConditions() {
                return Arrays.asList(((MixinLootModifier)modifier).getConditions());
            }
        };
    }

    @NotNull
    private static IGlobalLootModifierPlugin.IRegistry getForgeRegistry(final Map<Class<?>, BiFunction<IServerUtils, IGlobalLootModifier, Optional<ILootModifier<?>>>> glmMap) {
        return new IGlobalLootModifierPlugin.IRegistry(){

            @Override
            public <T> void registerGlobalLootModifier(Class<T> type, BiFunction<IServerUtils, T, Optional<ILootModifier<?>>> getter) {
                glmMap.put(type, (u, t) -> (Optional)getter.apply((IServerUtils)u, (Object)t));
            }
        };
    }
}

