/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.forge.platform;

import com.google.common.base.Suppliers;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.forge.mixin.MixinLootTableForge;
import com.yanny.ali.platform.services.IPlatformHelper;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

public class ForgePlatformHelper
implements IPlatformHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Supplier<List<IPlugin>> pluginsSupplier = Suppliers.memoize(this::loadPlugins);

    @Override
    public List<LootPool> getLootPools(LootTable table) {
        return ((MixinLootTableForge)table).getPools();
    }

    @Override
    public List<IPlugin> getPlugins() {
        return this.pluginsSupplier.get();
    }

    @Override
    public Path getConfiguration() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public SpawnEggItem getSpawnEggItem(EntityType<?> entityType) {
        return ForgeSpawnEggItem.fromEntityType(entityType);
    }

    @NotNull
    private List<IPlugin> loadPlugins() {
        LinkedList<IPlugin> plugins = new LinkedList<IPlugin>();
        Type type = Type.getType(AliEntrypoint.class);
        for (ModFileScanData scanData : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotationData : scanData.getAnnotations()) {
                if (!type.equals((Object)annotationData.annotationType())) continue;
                try {
                    Class<?> clazz = Class.forName(annotationData.memberName());
                    if (IPlugin.class.isAssignableFrom(clazz)) {
                        Class<IPlugin> pluginClass = clazz.asSubclass(IPlugin.class);
                        IPlugin plugin = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!ModList.get().isLoaded(plugin.getModId())) continue;
                        plugins.add(plugin);
                        LOGGER.info("Registered ALI plugin [{}] {}", (Object)plugin.getModId(), (Object)plugin.getClass().getCanonicalName());
                        continue;
                    }
                    LOGGER.warn("{} doesn't implement {}", (Object)annotationData.memberName(), (Object)IPlugin.class.getName());
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to load plugin with error: {}", (Object)t.getMessage());
                    t.printStackTrace();
                }
            }
        }
        LOGGER.info("Found {} plugin(s)", (Object)plugins.size());
        return plugins;
    }
}

