/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.biomespy.biome;

import com.moepus.biomespy.biome.BiomeEnvelopeSelector;
import com.moepus.biomespy.biome.BiomeNoiseCheckState;
import com.moepus.biomespy.biome.LazyBiomeNoiseChecker;
import com.moepus.biomespy.compat.alexscaves.AlexBiome;
import com.moepus.biomespy.compat.alexscaves.AlexsCavesCompat;
import com.moepus.biomespy.compat.terrablender.TerraBiome;
import com.moepus.biomespy.compat.terrablender.TerrablenderCompat;
import com.moepus.biomespy.mixin.MultiNoiseBiomeSourceAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import org.jetbrains.annotations.NotNull;

public class BiomeFinder {
    public static Pair<BlockPos, Holder<Biome>> findClosestBiome3d(@NotNull BlockPos pos, int radius, int horizontalStep, int verticalStep, Predicate<Holder<Biome>> biomePredicate, Climate.Sampler sampler, LevelReader level, MultiNoiseBiomeSource biomeSource) {
        Set<Holder<Biome>> set = biomeSource.m_207840_().stream().filter(biomePredicate).collect(Collectors.toUnmodifiableSet());
        if (set.isEmpty()) {
            return null;
        }
        Climate.ParameterList<Holder<Biome>> parameters = ((MultiNoiseBiomeSourceAccessor)biomeSource).invokeParameters();
        BiomeEnvelopeSelector envelopeSelector = new BiomeEnvelopeSelector(set, parameters, biomeSource);
        BiomeNoiseCheckState noiseCheckState = new BiomeNoiseCheckState();
        int i = Math.floorDiv(radius * 2, horizontalStep);
        int[] heights = Mth.m_216250_((int)pos.m_123342_(), (int)(level.m_141937_() + 1), (int)level.m_151558_(), (int)verticalStep).toArray();
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.m_121935_((BlockPos)BlockPos.f_121853_, (int)i, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int x = pos.m_123341_() + blockpos$mutableblockpos.m_123341_() * horizontalStep;
            int z = pos.m_123343_() + blockpos$mutableblockpos.m_123343_() * horizontalStep;
            LazyBiomeNoiseChecker biomeChecker = new LazyBiomeNoiseChecker(envelopeSelector, parameters, x, z);
            for (int y : heights) {
                Holder<Biome> alexBiome;
                if (AlexsCavesCompat.ALEXS_CAVES_INSTALLED && (alexBiome = AlexBiome.getAlexsCavesBiome(envelopeSelector, sampler, x, y, z)) != null) {
                    if (!set.contains(alexBiome)) continue;
                    return Pair.of((Object)new BlockPos(x, y, z), alexBiome);
                }
                if (!biomeChecker.matches(sampler, noiseCheckState, y)) continue;
                Climate.TargetPoint climate = biomeChecker.toTargetPoint(sampler, y);
                Holder<Biome> holder = TerrablenderCompat.TERRABLENDER_INSTALLED ? TerraBiome.getNoiseBiome(parameters, climate, x, y, z) : biomeSource.m_204269_(climate);
                if (!set.contains(holder)) continue;
                return Pair.of((Object)new BlockPos(x, y, z), holder);
            }
        }
        return null;
    }
}

