/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.biomespy.biome;

import com.moepus.biomespy.biome.BiomeEnvelope;
import com.moepus.biomespy.compat.alexscaves.AlexBiome;
import com.moepus.biomespy.compat.alexscaves.AlexsCavesCompat;
import com.moepus.biomespy.compat.terrablender.IParameterListExtendedInfo;
import com.moepus.biomespy.compat.terrablender.TerraBiome;
import com.moepus.biomespy.compat.terrablender.TerrablenderCompat;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;

public class BiomeEnvelopeSelector {
    private final Map<Integer, BiomeEnvelope> envelopeMap;
    private final Map<Class<?>, Object> platformData = new HashMap();

    public BiomeEnvelopeSelector(Collection<Holder<Biome>> biomes, Climate.ParameterList<Holder<Biome>> parameters, MultiNoiseBiomeSource biomeSource) {
        this.envelopeMap = new HashMap<Integer, BiomeEnvelope>();
        if (TerrablenderCompat.TERRABLENDER_INSTALLED && ((IParameterListExtendedInfo)parameters).biomeSpy$terraBlenderEnabled()) {
            ((IParameterListExtendedInfo)parameters).biomeSpy$visitAllEnvelopes((index, map) -> {
                BiomeEnvelope combinedEnvelope = new BiomeEnvelope();
                combinedEnvelope.impossible = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (!biomes.contains(entry.getKey())) continue;
                    combinedEnvelope.impossible = false;
                    combinedEnvelope.add((BiomeEnvelope)entry.getValue());
                }
                this.envelopeMap.put((Integer)index, combinedEnvelope);
            });
        } else {
            BiomeEnvelope combinedEnvelope = new BiomeEnvelope();
            combinedEnvelope.impossible = true;
            for (Pair pair : parameters.m_186850_()) {
                if (!biomes.contains(pair.getSecond())) continue;
                combinedEnvelope.impossible = false;
                combinedEnvelope.add((Climate.ParameterPoint)pair.getFirst());
            }
            this.envelopeMap.put(0, combinedEnvelope);
        }
        for (Integer i : this.envelopeMap.keySet()) {
            BiomeEnvelope env = this.envelopeMap.get(i);
            if (env.isValid()) continue;
            this.envelopeMap.put(i, new BiomeEnvelope());
        }
        if (AlexsCavesCompat.ALEXS_CAVES_INSTALLED) {
            AlexBiome.initAlexsCavesData(this, biomes, parameters, biomeSource);
        }
    }

    public BiomeEnvelope getEnvelope(Climate.ParameterList<Holder<Biome>> parameters, int qx, int qy, int qz) {
        if (TerrablenderCompat.TERRABLENDER_INSTALLED) {
            int uniqueness = TerraBiome.getUniqueness(parameters, qx, qy, qz);
            return this.envelopeMap.get(uniqueness);
        }
        return this.envelopeMap.get(0);
    }

    public <T> void setPlatformData(Class<?> key, T data) {
        this.platformData.put(key, data);
    }

    public Object getPlatformData(Class<?> key) {
        return this.platformData.get(key);
    }
}

