/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.util.EntityTickerAccessor;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class ClientEntityMixin
implements EntityTickerAccessor {
    @Shadow
    @Final
    protected RandomSource f_19796_;
    @Unique
    private final Entity subtleEffects$me = (Entity)this;
    @Unique
    private final Int2ObjectMap<EntityTicker<?>> subtleEffects$tickers = new Int2ObjectOpenHashMap();
    @Unique
    private double subtleEffects$nextCobwebSound = 0.5;
    @Unique
    private Vec3 subtleEffects$lastPos = Vec3.f_82478_;

    @Inject(method={"playEntityOnFireExtinguishedSound"}, at={@At(value="TAIL")})
    private void addExtinguishParticles(CallbackInfo ci) {
        Level level = this.subtleEffects$me.m_9236_();
        if (level.m_5776_() && ModConfigs.ENTITIES.burning.extinguishSteam) {
            AABB boundingBox = this.subtleEffects$me.m_20191_();
            for (int x = Mth.m_14107_((double)boundingBox.f_82288_); x < Mth.m_14165_((double)boundingBox.f_82291_); ++x) {
                for (int y = Mth.m_14107_((double)boundingBox.f_82289_); y < Mth.m_14165_((double)boundingBox.f_82292_); ++y) {
                    for (int z = Mth.m_14107_((double)boundingBox.f_82290_); z < Mth.m_14165_((double)boundingBox.f_82293_); ++z) {
                        BlockPos abovePos;
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = level.m_8055_(pos);
                        FluidState fluidState = level.m_6425_(pos);
                        double fluidHeight = Math.max(Util.getCauldronFillHeight(state), (double)fluidState.m_76155_((BlockGetter)level, pos));
                        if (!(fluidHeight > 0.0) || !fluidState.m_192917_((Fluid)Fluids.f_76193_) && !state.m_60713_(Blocks.f_152476_) || Util.isSolidOrNotEmpty(level, abovePos = pos.m_7494_())) continue;
                        for (int i = 0; i < 5; ++i) {
                            level.m_7106_((ParticleOptions)ModParticles.STEAM.get(), (double)pos.m_123341_() + this.f_19796_.m_188500_(), (double)pos.m_123342_() + fluidHeight + MathUtil.nextDouble(this.f_19796_, 0.5), (double)pos.m_123343_() + this.f_19796_.m_188500_(), 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"onInsideBlock"}, at={@At(value="HEAD")})
    private void inside(BlockState state, CallbackInfo ci) {
        if (this.subtleEffects$me.m_9236_().f_46443_ && ModConfigs.BLOCKS.cobwebMovementSounds && (double)this.subtleEffects$me.f_146794_ > this.subtleEffects$nextCobwebSound && state.m_60713_(Blocks.f_50033_) && this.subtleEffects$lastPos.m_82557_(this.subtleEffects$me.m_20182_()) > 0.5) {
            this.subtleEffects$nextCobwebSound += 0.5;
            this.subtleEffects$lastPos = this.subtleEffects$me.m_20182_();
            SoundType soundType = state.m_60827_();
            Util.playClientSound(this.subtleEffects$me, soundType.m_56776_(), this.subtleEffects$me.m_5720_(), soundType.m_56773_() * 0.15f, soundType.m_56774_());
        }
    }

    @Inject(method={"doWaterSplashEffect"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;floor(D)I")}, cancellable=true)
    private void doClientWaterSplash(CallbackInfo ci) {
        if (ParticleSpawnUtil.spawnSplashEffects(this.subtleEffects$me, this.subtleEffects$me.m_9236_(), ModParticles.WATER_SPLASH_EMITTER.get(), (TagKey<Fluid>)FluidTags.f_13131_)) {
            ci.cancel();
        }
    }

    @Override
    public Int2ObjectMap<EntityTicker<?>> subtleEffects$getTickers() {
        return this.subtleEffects$tickers;
    }
}

