/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.world.saved_data;

import dev.muon.otherworld.Otherworld;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class StructureSpawnState
extends SavedData {
    private static final String DATA_NAME = "otherworld_structure_spawn_state";
    private final LongSet maledictusSpawnedStructures = new LongOpenHashSet();

    private StructureSpawnState(LongSet spawnedSet) {
        this.maledictusSpawnedStructures.addAll((LongCollection)spawnedSet);
    }

    public StructureSpawnState() {
    }

    public boolean hasMaledictusSpawned(long structureCenterLong) {
        return this.maledictusSpawnedStructures.contains(structureCenterLong);
    }

    public void markMaledictusSpawned(long structureCenterLong) {
        if (this.maledictusSpawnedStructures.add(structureCenterLong)) {
            this.m_77762_();
        }
    }

    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        ListTag listTag = new ListTag();
        LongIterator longIterator = this.maledictusSpawnedStructures.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            listTag.add((Object)LongTag.m_128882_((long)posLong));
        }
        pCompoundTag.m_128365_("MaledictusSpawned", (Tag)listTag);
        return pCompoundTag;
    }

    public static StructureSpawnState load(CompoundTag pCompoundTag) {
        LongOpenHashSet loadedSet = new LongOpenHashSet();
        ListTag listTag = pCompoundTag.m_128437_("MaledictusSpawned", 4);
        for (int i = 0; i < listTag.size(); ++i) {
            Tag tag = listTag.get(i);
            if (tag instanceof LongTag) {
                LongTag longTag = (LongTag)tag;
                loadedSet.add(longTag.m_7046_());
                continue;
            }
            Otherworld.LOGGER.warn("Found non-LongTag in MaledictusSpawned list: {}", (Object)tag);
        }
        return new StructureSpawnState((LongSet)loadedSet);
    }

    public static StructureSpawnState get(ServerLevel level) {
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        return (StructureSpawnState)storage.m_164861_(StructureSpawnState::load, StructureSpawnState::new, DATA_NAME);
    }
}

