/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.world.saved_data;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class StructureRegenerationState
extends SavedData {
    private static final String DATA_NAME = "otherworld_structure_regeneration";
    private final Map<UUID, Set<String>> playerRegenerations = new HashMap<UUID, Set<String>>();
    private final Map<ResourceLocation, Long> structureCooldowns = new HashMap<ResourceLocation, Long>();
    private final Map<ResourceLocation, StructureInteraction> structureInteractions = new HashMap<ResourceLocation, StructureInteraction>();
    private static final long COOLDOWN_DURATION = 36000L;

    public static StructureRegenerationState get(ServerLevel level) {
        return (StructureRegenerationState)level.m_7654_().m_129783_().m_8895_().m_164861_(StructureRegenerationState::load, StructureRegenerationState::new, DATA_NAME);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag playerData = new CompoundTag();
        this.playerRegenerations.forEach((uuid, structures) -> {
            ListTag list = new ListTag();
            structures.forEach(structure -> list.add((Object)StringTag.m_129297_((String)structure)));
            playerData.m_128365_(uuid.toString(), (Tag)list);
        });
        tag.m_128365_("PlayerData", (Tag)playerData);
        CompoundTag cooldownData = new CompoundTag();
        this.structureCooldowns.forEach((structure, time) -> cooldownData.m_128356_(structure.toString(), time.longValue()));
        tag.m_128365_("Cooldowns", (Tag)cooldownData);
        CompoundTag interactionData = new CompoundTag();
        this.structureInteractions.forEach((structure, interaction) -> {
            CompoundTag interactionTag = new CompoundTag();
            interactionTag.m_128362_("PlayerId", interaction.playerId);
            interactionTag.m_128356_("Timestamp", interaction.timestamp);
            interactionTag.m_128359_("Type", interaction.type.name());
            interactionData.m_128365_(structure.toString(), (Tag)interactionTag);
        });
        tag.m_128365_("Interactions", (Tag)interactionData);
        return tag;
    }

    private static StructureRegenerationState load(CompoundTag tag) {
        StructureRegenerationState data = new StructureRegenerationState();
        CompoundTag playerData = tag.m_128469_("PlayerData");
        for (Object uuidStr : playerData.m_128431_()) {
            UUID uuid = UUID.fromString((String)uuidStr);
            HashSet<String> structures = new HashSet<String>();
            ListTag list = playerData.m_128437_((String)uuidStr, 8);
            for (int i = 0; i < list.size(); ++i) {
                structures.add(list.m_128778_(i));
            }
            data.playerRegenerations.put(uuid, structures);
        }
        CompoundTag cooldownData = tag.m_128469_("Cooldowns");
        for (String structureId : cooldownData.m_128431_()) {
            data.structureCooldowns.put(new ResourceLocation(structureId), cooldownData.m_128454_(structureId));
        }
        CompoundTag interactionData = tag.m_128469_("Interactions");
        for (String structureId : interactionData.m_128431_()) {
            CompoundTag interactionTag = interactionData.m_128469_(structureId);
            UUID playerId = interactionTag.m_128342_("PlayerId");
            long timestamp = interactionTag.m_128454_("Timestamp");
            InteractionType type = InteractionType.valueOf(interactionTag.m_128461_("Type"));
            data.structureInteractions.put(new ResourceLocation(structureId), new StructureInteraction(playerId, timestamp, type));
        }
        return data;
    }

    private static String getStructureInstanceId(ResourceLocation structureId, BlockPos centerPos) {
        return structureId.toString() + ":" + centerPos.m_123341_() + ":" + centerPos.m_123343_();
    }

    public boolean hasPlayerRegeneratedStructure(UUID playerId, ResourceLocation structure, BlockPos centerPos) {
        String instanceId = StructureRegenerationState.getStructureInstanceId(structure, centerPos);
        return this.playerRegenerations.getOrDefault(playerId, Collections.emptySet()).contains(instanceId);
    }

    public void markStructureRegenerated(UUID playerId, ResourceLocation structure, BlockPos centerPos) {
        String instanceId = StructureRegenerationState.getStructureInstanceId(structure, centerPos);
        this.playerRegenerations.computeIfAbsent(playerId, k -> new HashSet()).add(instanceId);
        this.m_77762_();
    }

    public boolean isStructureOnCooldown(ResourceLocation structure, long currentTime) {
        return this.structureCooldowns.containsKey(structure) && currentTime - this.structureCooldowns.get(structure) < 36000L;
    }

    public void setStructureCooldown(ResourceLocation structure, long time) {
        this.structureCooldowns.put(structure, time);
        this.m_77762_();
    }

    public long getRemainingCooldown(ResourceLocation structure, long currentTime) {
        if (!this.structureCooldowns.containsKey(structure)) {
            return 0L;
        }
        long remaining = 36000L - (currentTime - this.structureCooldowns.get(structure));
        return Math.max(0L, remaining);
    }

    public void recordStructureInteraction(ResourceLocation structure, UUID playerId, long timestamp, InteractionType type) {
        this.structureInteractions.put(structure, new StructureInteraction(playerId, timestamp, type));
        this.m_77762_();
    }

    public boolean hasRecentInteraction(ResourceLocation structure, long currentTime, int timeoutSeconds) {
        StructureInteraction interaction = this.structureInteractions.get(structure);
        if (interaction == null) {
            return false;
        }
        long timeoutTicks = (long)timeoutSeconds * 20L;
        return currentTime - interaction.timestamp < timeoutTicks;
    }

    public StructureInteraction getLastInteraction(ResourceLocation structure) {
        return this.structureInteractions.get(structure);
    }

    public void clearStructureInteraction(ResourceLocation structure) {
        this.structureInteractions.remove(structure);
        this.m_77762_();
    }

    public void cleanupOldInteractions(long currentTime, int timeoutSeconds) {
        long timeoutTicks = (long)timeoutSeconds * 20L;
        this.structureInteractions.entrySet().removeIf(entry -> {
            StructureInteraction interaction = (StructureInteraction)entry.getValue();
            return currentTime - interaction.timestamp > timeoutTicks;
        });
    }

    public static enum InteractionType {
        CHEST_OPENED,
        ENTITY_INTERACTED,
        ENTITY_DAMAGED;

    }

    public static class StructureInteraction {
        public final UUID playerId;
        public final long timestamp;
        public final InteractionType type;

        public StructureInteraction(UUID playerId, long timestamp, InteractionType type) {
            this.playerId = playerId;
            this.timestamp = timestamp;
            this.type = type;
        }
    }
}

