/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.world.saved_data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class PortalFrameState
extends SavedData {
    private static final String DATA_NAME = "otherworld_portal_frame_state";
    private final Map<UUID, List<FrameData>> bossToFramesMap = new HashMap<UUID, List<FrameData>>();
    private static final String TAG_PORTAL_FRAMES = "PortalFrames";
    private static final String TAG_BOSS_UUID = "BossUUID";
    private static final String TAG_FRAME_DATA_LIST = "FrameDataList";
    private static final String TAG_FRAME_POS = "Pos";
    private static final String TAG_FRAME_STATE = "State";

    public static PortalFrameState load(CompoundTag tag) {
        PortalFrameState state = new PortalFrameState();
        ListTag listTag = tag.m_128437_(TAG_PORTAL_FRAMES, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag entryTag = listTag.m_128728_(i);
            UUID bossUUID = entryTag.m_128342_(TAG_BOSS_UUID);
            ArrayList<FrameData> frameDataList = new ArrayList<FrameData>();
            ListTag frameListTag = entryTag.m_128437_(TAG_FRAME_DATA_LIST, 10);
            for (Tag frameTag : frameListTag) {
                CompoundTag frameCompound = (CompoundTag)frameTag;
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)frameCompound.m_128469_(TAG_FRAME_POS));
                BlockState blockState = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)frameCompound.m_128469_(TAG_FRAME_STATE));
                frameDataList.add(new FrameData(pos, blockState));
            }
            state.bossToFramesMap.put(bossUUID, frameDataList);
        }
        return state;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag listTag = new ListTag();
        for (Map.Entry<UUID, List<FrameData>> entry : this.bossToFramesMap.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128362_(TAG_BOSS_UUID, entry.getKey());
            ListTag frameListTag = new ListTag();
            for (FrameData frameData : entry.getValue()) {
                CompoundTag frameCompound = new CompoundTag();
                frameCompound.m_128365_(TAG_FRAME_POS, (Tag)NbtUtils.m_129224_((BlockPos)frameData.pos));
                frameCompound.m_128365_(TAG_FRAME_STATE, (Tag)NbtUtils.m_129202_((BlockState)frameData.blockState));
                frameListTag.add((Object)frameCompound);
            }
            entryTag.m_128365_(TAG_FRAME_DATA_LIST, (Tag)frameListTag);
            listTag.add((Object)entryTag);
        }
        tag.m_128365_(TAG_PORTAL_FRAMES, (Tag)listTag);
        return tag;
    }

    public static PortalFrameState get(ServerLevel level) {
        return (PortalFrameState)level.m_7654_().m_129783_().m_8895_().m_164861_(PortalFrameState::load, PortalFrameState::new, DATA_NAME);
    }

    public void addPortal(UUID bossUUID, List<FrameData> frameDataList) {
        this.bossToFramesMap.put(bossUUID, frameDataList);
        this.m_77762_();
    }

    public void removePortal(UUID bossUUID) {
        if (this.bossToFramesMap.remove(bossUUID) != null) {
            this.m_77762_();
        }
    }

    @Nullable
    public List<FrameData> getFrameData(UUID bossUUID) {
        return this.bossToFramesMap.get(bossUUID);
    }

    public static class FrameData {
        public final BlockPos pos;
        public final BlockState blockState;

        public FrameData(BlockPos pos, BlockState blockState) {
            this.pos = pos;
            this.blockState = blockState;
        }
    }
}

