/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.world.saved_data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class EndPortalLinks
extends SavedData {
    private static final String DATA_NAME = "otherworld_end_portal_links";
    private final Map<UUID, BlockPos> playerToPortalPos = new HashMap<UUID, BlockPos>();
    private static final String TAG_PORTAL_LINKS = "PortalLinks";
    private static final String TAG_PORTAL_POS = "PortalPos";

    public static EndPortalLinks load(CompoundTag tag) {
        EndPortalLinks links = new EndPortalLinks();
        if (tag.m_128441_(TAG_PORTAL_LINKS)) {
            CompoundTag linksTag = tag.m_128469_(TAG_PORTAL_LINKS);
            for (String key : linksTag.m_128431_()) {
                try {
                    UUID playerUUID = UUID.fromString(key);
                    CompoundTag entryTag = linksTag.m_128469_(key);
                    if (!entryTag.m_128441_(TAG_PORTAL_POS)) continue;
                    BlockPos portalPos = NbtUtils.m_129239_((CompoundTag)entryTag.m_128469_(TAG_PORTAL_POS));
                    links.playerToPortalPos.put(playerUUID, portalPos);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return links;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag linksTag = new CompoundTag();
        for (Map.Entry<UUID, BlockPos> entry : this.playerToPortalPos.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_(TAG_PORTAL_POS, (Tag)NbtUtils.m_129224_((BlockPos)entry.getValue()));
            linksTag.m_128365_(entry.getKey().toString(), (Tag)entryTag);
        }
        tag.m_128365_(TAG_PORTAL_LINKS, (Tag)linksTag);
        return tag;
    }

    public static EndPortalLinks get(ServerLevel level) {
        return (EndPortalLinks)level.m_7654_().m_129783_().m_8895_().m_164861_(EndPortalLinks::load, EndPortalLinks::new, DATA_NAME);
    }

    public void setPortalPosition(UUID playerUUID, BlockPos portalPos) {
        this.playerToPortalPos.put(playerUUID, portalPos);
        this.m_77762_();
    }

    public BlockPos getPortalPosition(UUID playerUUID) {
        return this.playerToPortalPos.get(playerUUID);
    }

    public void removePortalPosition(UUID playerUUID) {
        if (this.playerToPortalPos.remove(playerUUID) != null) {
            this.m_77762_();
        }
    }
}

