/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.world.saved_data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class ActiveRitualBossTracker
extends SavedData {
    private static final String MAP_NAME = "otherworld_active_ritual_bosses";
    private final Map<UUID, BlockPos> trackedBosses = new HashMap<UUID, BlockPos>();
    private static final String TAG_BOSSES = "TrackedBosses";
    private static final String TAG_BOSS_UUID = "BossUUID";
    private static final String TAG_ALTAR_POS = "AltarPos";

    public static ActiveRitualBossTracker load(CompoundTag tag) {
        ActiveRitualBossTracker tracker = new ActiveRitualBossTracker();
        ListTag listTag = tag.m_128437_(TAG_BOSSES, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag entryTag = listTag.m_128728_(i);
            UUID bossUUID = entryTag.m_128342_(TAG_BOSS_UUID);
            BlockPos altarPos = NbtUtils.m_129239_((CompoundTag)entryTag.m_128469_(TAG_ALTAR_POS));
            tracker.trackedBosses.put(bossUUID, altarPos);
        }
        return tracker;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag listTag = new ListTag();
        for (Map.Entry<UUID, BlockPos> entry : this.trackedBosses.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128362_(TAG_BOSS_UUID, entry.getKey());
            entryTag.m_128365_(TAG_ALTAR_POS, (Tag)NbtUtils.m_129224_((BlockPos)entry.getValue()));
            listTag.add((Object)entryTag);
        }
        tag.m_128365_(TAG_BOSSES, (Tag)listTag);
        return tag;
    }

    public static ActiveRitualBossTracker get(ServerLevel level) {
        return (ActiveRitualBossTracker)level.m_7654_().m_129783_().m_8895_().m_164861_(ActiveRitualBossTracker::load, ActiveRitualBossTracker::new, MAP_NAME);
    }

    public void addTrackedBoss(UUID bossUUID, BlockPos portalCenterPos) {
        this.trackedBosses.put(bossUUID, portalCenterPos);
        this.m_77762_();
    }

    public void removeTrackedBoss(UUID bossUUID) {
        if (this.trackedBosses.remove(bossUUID) != null) {
            this.m_77762_();
        }
    }

    @Nullable
    public BlockPos getPortalCenterForBoss(UUID bossUUID) {
        return this.trackedBosses.get(bossUUID);
    }

    public boolean isBossTracked(UUID bossUUID) {
        return this.trackedBosses.containsKey(bossUUID);
    }
}

