/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.structure;

import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.muon.otherworld.config.OtherworldConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureRegenerator {
    private static final Logger LOGGER = LogManager.getLogger();

    public static RegenerationResult regenerateStructure(ServerLevel level, BlockPos pos, ResourceLocation structureId) {
        if (!StructureRegenerator.isValidStructure(structureId)) {
            return new RegenerationResult(false, "Invalid structure");
        }
        StructureStart structureStart = StructureRegenerator.findNearestStructure(level, pos, structureId);
        if (structureStart == null || !structureStart.m_73603_()) {
            return new RegenerationResult(false, "Structure not found or invalid");
        }
        LOGGER.info("Found structure {} at {}", (Object)structureId, (Object)structureStart.m_73601_().m_162394_());
        BlockPos claimedChunkCenter = StructureRegenerator.isAnyClaimed(level, structureStart.m_73601_());
        if (claimedChunkCenter != null) {
            String claimResult = String.format("Chunk at (%d, ~, %d) is claimed", claimedChunkCenter.m_123341_(), claimedChunkCenter.m_123343_());
            LOGGER.info("Structure {} contains claimed chunks. Regeneration cancelled. {}", (Object)structureId, (Object)claimResult);
            return new RegenerationResult(false, claimResult);
        }
        long startTime = System.currentTimeMillis();
        BoundingBox boundingBox = structureStart.m_73601_();
        ChunkPos chunkPosMin = new ChunkPos(SectionPos.m_123171_((int)boundingBox.m_162395_()), SectionPos.m_123171_((int)boundingBox.m_162398_()));
        ChunkPos chunkPosMax = new ChunkPos(SectionPos.m_123171_((int)boundingBox.m_162399_()), SectionPos.m_123171_((int)boundingBox.m_162401_()));
        StructureRegenerator.removeExistingEntities(level, boundingBox);
        StructureRegenerator.forceResetLootContainers(level, boundingBox);
        ChunkPos.m_45599_((ChunkPos)chunkPosMin, (ChunkPos)chunkPosMax).forEach(chunkPos -> {
            structureStart.m_226850_((WorldGenLevel)level, level.m_215010_(), level.m_7726_().m_8481_(), level.m_213780_(), new BoundingBox(chunkPos.m_45604_(), level.m_141937_(), chunkPos.m_45605_(), chunkPos.m_45608_(), level.m_151558_(), chunkPos.m_45609_()), chunkPos);
            level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_8092_(true);
        });
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        LOGGER.info("Regenerated structure {} in {} ms", (Object)structureId, (Object)duration);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12089_, SoundSource.PLAYERS, 2.0f, 0.5f);
        return new RegenerationResult(true, duration + " ms");
    }

    public static BlockPos isAnyClaimed(ServerLevel level, BoundingBox boundingBox) {
        if (ModList.get().isLoaded("ftbchunks")) {
            if (!FTBChunksAPI.api().isManagerLoaded()) {
                LOGGER.warn("FTB Chunks manager is not loaded. This shouldn't happen! Assuming no chunks are claimed.");
                return null;
            }
            ClaimedChunkManager chunkManager = FTBChunksAPI.api().getManager();
            ResourceKey dimension = level.m_46472_();
            int minChunkX = boundingBox.m_162395_() >> 4;
            int minChunkZ = boundingBox.m_162398_() >> 4;
            int maxChunkX = boundingBox.m_162399_() >> 4;
            int maxChunkZ = boundingBox.m_162401_() >> 4;
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    ChunkDimPos chunkDimPos = new ChunkDimPos(dimension, chunkX, chunkZ);
                    ClaimedChunk claimedChunk = chunkManager.getChunk(chunkDimPos);
                    if (claimedChunk == null) continue;
                    return new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8);
                }
            }
        } else {
            LOGGER.info("FTB Chunks is not loaded. No claim check performed.");
        }
        return null;
    }

    public static boolean isValidStructure(ResourceLocation structureId) {
        return OtherworldConfig.get().isStructureWhitelisted(structureId);
    }

    private static void removeExistingEntities(ServerLevel level, BoundingBox boundingBox) {
        List entitiesToRemove = level.m_6443_(Entity.class, new AABB((double)boundingBox.m_162395_(), (double)boundingBox.m_162396_(), (double)boundingBox.m_162398_(), (double)(boundingBox.m_162399_() + 1), (double)(boundingBox.m_162400_() + 1), (double)(boundingBox.m_162401_() + 1)), StructureRegenerator::shouldRemoveEntity);
        entitiesToRemove.forEach(Entity::m_146870_);
    }

    private static boolean shouldRemoveEntity(Entity entity) {
        if (entity instanceof Mob) {
            if (entity instanceof OwnableEntity && ((OwnableEntity)entity).m_269323_() instanceof Player) {
                return false;
            }
            if (entity.m_217005_() && entity.m_6688_() instanceof Player) {
                return false;
            }
        }
        return entity instanceof Painting || entity instanceof ItemFrame || entity instanceof ArmorStand || entity instanceof AbstractMinecart || entity instanceof Boat || entity instanceof LeashFenceKnotEntity || entity instanceof Arrow || entity instanceof SpectralArrow;
    }

    private static void forceResetLootContainers(ServerLevel level, BoundingBox boundingBox) {
        BlockPos.m_121976_((int)boundingBox.m_162395_(), (int)boundingBox.m_162396_(), (int)boundingBox.m_162398_(), (int)boundingBox.m_162399_(), (int)boundingBox.m_162400_(), (int)boundingBox.m_162401_()).forEach(pos -> {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
                container.m_59640_(null);
                container.m_6211_();
                container.m_6596_();
                level.m_7471_(pos, false);
            }
        });
    }

    public static StructureStart findNearestStructure(ServerLevel level, BlockPos pos, ResourceLocation structureId) {
        HashMap<Structure, StructureStart> structures = new HashMap<Structure, StructureStart>();
        int searchRadius = OtherworldConfig.get().structureSearchRadius;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                ChunkPos chunkPos = new ChunkPos((pos.m_123341_() >> 4) + x, (pos.m_123343_() >> 4) + z);
                Map structuresInChunk = level.m_215010_().m_220522_(chunkPos.m_45615_());
                for (Map.Entry entry : structuresInChunk.entrySet()) {
                    StructureStart start;
                    if (!level.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)((Structure)entry.getKey())).equals((Object)structureId) || (start = level.m_215010_().m_220512_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)0), (Structure)entry.getKey(), (StructureAccess)level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_))) == null || !start.m_73603_()) continue;
                    structures.put((Structure)entry.getKey(), start);
                }
            }
        }
        if (structures.isEmpty()) {
            return null;
        }
        return structures.values().stream().min((s1, s2) -> Double.compare(s1.m_73601_().m_162394_().m_123331_((Vec3i)pos), s2.m_73601_().m_162394_().m_123331_((Vec3i)pos))).orElse(null);
    }

    public static class RegenerationResult {
        public final boolean success;
        public final String message;

        public RegenerationResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }
    }
}

