/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.sound;

import dev.muon.otherworld.client.ClientSoundHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class SoundPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("otherworld", "sound_channel"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int nextID() {
        return packetId++;
    }

    public static void register() {
        INSTANCE.registerMessage(SoundPacketHandler.nextID(), PlayGlobalSoundPacket.class, PlayGlobalSoundPacket::encode, PlayGlobalSoundPacket::decode, PlayGlobalSoundPacket::handle);
    }

    public static class PlayGlobalSoundPacket {
        private final ResourceLocation soundLocation;
        private final float volume;
        private final float pitch;

        public PlayGlobalSoundPacket(ResourceLocation soundLocation, float volume, float pitch) {
            this.soundLocation = soundLocation;
            this.volume = volume;
            this.pitch = pitch;
        }

        public static void encode(PlayGlobalSoundPacket packet, FriendlyByteBuf buffer) {
            buffer.m_130085_(packet.soundLocation);
            buffer.writeFloat(packet.volume);
            buffer.writeFloat(packet.pitch);
        }

        public static PlayGlobalSoundPacket decode(FriendlyByteBuf buffer) {
            return new PlayGlobalSoundPacket(buffer.m_130281_(), buffer.readFloat(), buffer.readFloat());
        }

        public static void handle(PlayGlobalSoundPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientSoundHandler.playGlobalSound(packet.soundLocation, packet.volume, packet.pitch)));
            ctx.get().setPacketHandled(true);
        }
    }
}

