/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.network;

import dev.muon.otherworld.client.ClientHeartTransformHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class HeartTransformPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"otherworld", (String)"heart_transform"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int nextID() {
        return packetId++;
    }

    public static void register() {
        INSTANCE.registerMessage(HeartTransformPacketHandler.nextID(), StartTransformPacket.class, StartTransformPacket::encode, StartTransformPacket::decode, StartTransformPacket::handle);
        INSTANCE.registerMessage(HeartTransformPacketHandler.nextID(), StopTransformPacket.class, StopTransformPacket::encode, StopTransformPacket::decode, StopTransformPacket::handle);
    }

    public static void sendStartTransform(ServerLevel level, int entityId, String transformType, double x, double y, double z) {
        INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, 64.0, level.m_46472_())), (Object)new StartTransformPacket(entityId, transformType));
    }

    public static void sendStopTransform(ServerLevel level, int entityId, String transformType, double x, double y, double z) {
        INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, 64.0, level.m_46472_())), (Object)new StopTransformPacket(entityId, transformType, x, y, z));
    }

    public static class StartTransformPacket {
        private final int entityId;
        private final String transformType;

        public StartTransformPacket(int entityId, String transformType) {
            this.entityId = entityId;
            this.transformType = transformType;
        }

        public static void encode(StartTransformPacket packet, FriendlyByteBuf buffer) {
            buffer.writeInt(packet.entityId);
            buffer.m_130070_(packet.transformType);
        }

        public static StartTransformPacket decode(FriendlyByteBuf buffer) {
            return new StartTransformPacket(buffer.readInt(), buffer.m_130277_());
        }

        public static void handle(StartTransformPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHeartTransformHandler.startTracking(packet.entityId, packet.transformType)));
            ctx.get().setPacketHandled(true);
        }
    }

    public static class StopTransformPacket {
        private final int entityId;
        private final String transformType;
        private final double x;
        private final double y;
        private final double z;

        public StopTransformPacket(int entityId, String transformType, double x, double y, double z) {
            this.entityId = entityId;
            this.transformType = transformType;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static void encode(StopTransformPacket packet, FriendlyByteBuf buffer) {
            buffer.writeInt(packet.entityId);
            buffer.m_130070_(packet.transformType);
            buffer.writeDouble(packet.x);
            buffer.writeDouble(packet.y);
            buffer.writeDouble(packet.z);
        }

        public static StopTransformPacket decode(FriendlyByteBuf buffer) {
            return new StopTransformPacket(buffer.readInt(), buffer.m_130277_(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }

        public static void handle(StopTransformPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ClientHeartTransformHandler.spawnFinalEffects(packet.x, packet.y, packet.z, packet.transformType);
                ClientHeartTransformHandler.stopTracking(packet.entityId);
            }));
            ctx.get().setPacketHandled(true);
        }
    }
}

