/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.network;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.client.ClientBossNarrationHandler;
import dev.muon.otherworld.event.ForgeEventHandlers;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class BossNarrationPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"otherworld", (String)"boss_narration"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int nextID() {
        return packetId++;
    }

    public static void register() {
        INSTANCE.registerMessage(BossNarrationPacketHandler.nextID(), OpenBossNarrationScreenPacket.class, OpenBossNarrationScreenPacket::encode, OpenBossNarrationScreenPacket::decode, OpenBossNarrationScreenPacket::handle);
        INSTANCE.registerMessage(BossNarrationPacketHandler.nextID(), CloseBossNarrationScreenPacket.class, CloseBossNarrationScreenPacket::encode, CloseBossNarrationScreenPacket::decode, CloseBossNarrationScreenPacket::handle);
    }

    public static class OpenBossNarrationScreenPacket {
        public static void encode(OpenBossNarrationScreenPacket packet, FriendlyByteBuf buffer) {
        }

        public static OpenBossNarrationScreenPacket decode(FriendlyByteBuf buffer) {
            return new OpenBossNarrationScreenPacket();
        }

        public static void handle(OpenBossNarrationScreenPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientBossNarrationHandler.openBossNarrationScreen()));
            ctx.get().setPacketHandled(true);
        }
    }

    public static class CloseBossNarrationScreenPacket {
        public static void encode(CloseBossNarrationScreenPacket packet, FriendlyByteBuf buffer) {
        }

        public static CloseBossNarrationScreenPacket decode(FriendlyByteBuf buffer) {
            return new CloseBossNarrationScreenPacket();
        }

        public static void handle(CloseBossNarrationScreenPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender != null) {
                    ForgeEventHandlers.removePlayerFromNarration(sender);
                    MinecraftServer server = sender.m_20194_();
                    if (server != null) {
                        ServerLevel endLevel = server.m_129880_(Level.f_46430_);
                        if (endLevel != null) {
                            sender.m_5489_(endLevel);
                        } else {
                            Otherworld.LOGGER.error("Could not find The End dimension to teleport player {}!", (Object)sender.m_7755_().getString());
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

