/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.mixin.compat.justlevelingfork;

import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.registry.RegistryCapabilities;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import com.seniors.justlevelingfork.registry.passive.Passive;
import dev.muon.otherworld.leveling.event.AptitudeChangedEvent;
import dev.muon.otherworld.leveling.event.PassiveChangedEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AptitudeCapability.class}, remap=false)
public class AptitudeCapabilityMixin {
    @Inject(method={"setAptitudeLevel"}, at={@At(value="RETURN")})
    private void onSetAptitudeLevel(Aptitude aptitude, int lvl, CallbackInfo ci) {
        AptitudeCapability self = (AptitudeCapability)this;
        Player player = this.otherworld$getPlayerFromCapability(self);
        if (player != null) {
            int oldLevel = self.getAptitudeLevel(aptitude);
            MinecraftForge.EVENT_BUS.post((Event)new AptitudeChangedEvent(player, aptitude.getName(), oldLevel, lvl));
        }
    }

    @Inject(method={"addAptitudeLevel"}, at={@At(value="RETURN")})
    private void onAddAptitudeLevel(Aptitude aptitude, int addLvl, CallbackInfo ci) {
        AptitudeCapability self = (AptitudeCapability)this;
        Player player = this.otherworld$getPlayerFromCapability(self);
        if (player != null) {
            int newLevel = self.getAptitudeLevel(aptitude);
            int oldLevel = newLevel - addLvl;
            MinecraftForge.EVENT_BUS.post((Event)new AptitudeChangedEvent(player, aptitude.getName(), oldLevel, newLevel));
        }
    }

    @Inject(method={"addPassiveLevel"}, at={@At(value="RETURN")})
    private void onAddPassiveLevel(Passive passive, int addLvl, CallbackInfo ci) {
        AptitudeCapability self = (AptitudeCapability)this;
        Player player = this.otherworld$getPlayerFromCapability(self);
        if (player != null) {
            int newLevel = self.getPassiveLevel(passive);
            int oldLevel = newLevel - addLvl;
            MinecraftForge.EVENT_BUS.post((Event)new PassiveChangedEvent(player, passive.getName(), oldLevel, newLevel));
        }
    }

    @Inject(method={"subPassiveLevel"}, at={@At(value="RETURN")})
    private void onSubPassiveLevel(Passive passive, int subLvl, CallbackInfo ci) {
        AptitudeCapability self = (AptitudeCapability)this;
        Player player = this.otherworld$getPlayerFromCapability(self);
        if (player != null) {
            int newLevel = self.getPassiveLevel(passive);
            int oldLevel = newLevel + subLvl;
            MinecraftForge.EVENT_BUS.post((Event)new PassiveChangedEvent(player, passive.getName(), oldLevel, newLevel));
        }
    }

    @Unique
    private Player otherworld$getPlayerFromCapability(AptitudeCapability capability) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
                for (Player player : level.m_6907_()) {
                    LazyOptional cap = player.getCapability(RegistryCapabilities.APTITUDE);
                    if (!cap.isPresent() || cap.resolve().get() != capability) continue;
                    return player;
                }
            }
        }
        return null;
    }
}

