/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.mixin.compat.autoleveling;

import com.gametechbc.traveloptics.entity.mobs.nightwarden_boss.NightwardenBossEntity;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import daripher.autoleveling.event.MobsLevelingEvents;
import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.config.OtherworldConfig;
import dev.muon.otherworld.leveling.EnhancedEntityLevelingSettings;
import dev.muon.otherworld.leveling.EnhancedEntityLevelingSettingsReloader;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import java.util.UUID;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MobsLevelingEvents.class}, remap=false)
public class MobLevelingEventsMixin {
    @Unique
    private static final TagKey<EntityType<?>> FIXED_LEVEL_ENTITIES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Otherworld.loc("fixed_level_entities"));
    @Unique
    private static final TagKey<EntityType<?>> PASSIVE_WHITELIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Otherworld.loc("passive_whitelist"));

    @ModifyReturnValue(method={"canHaveLevel"}, at={@At(value="RETURN")})
    private static boolean modifyCanHaveLevel(boolean original, Entity entity) {
        if (original && entity instanceof Animal) {
            Animal animal = (Animal)entity;
            if (OtherworldConfig.get().cancelLevelsForPassives) {
                if (entity.m_6095_().m_204039_(PASSIVE_WHITELIST)) {
                    return true;
                }
                AttributeInstance attackDamageAttribute = animal.m_21051_(Attributes.f_22281_);
                if (attackDamageAttribute == null || attackDamageAttribute.m_22135_() <= 0.0) {
                    return false;
                }
            }
        }
        if (entity instanceof NightwardenBossEntity) {
            return true;
        }
        if (entity instanceof TargetDummyEntity || entity instanceof AntiMagicSusceptible && !(entity instanceof MagicSummon)) {
            return false;
        }
        return original;
    }

    @ModifyReturnValue(method={"createLevelForEntity"}, at={@At(value="RETURN")})
    private static int modifyLevel(int original, LivingEntity entity, double distance) {
        if (entity.m_6095_().m_204039_(FIXED_LEVEL_ENTITIES)) {
            return original;
        }
        int modifiedLevel = original;
        if (OtherworldConfig.get().enableStructureLevelBonus) {
            modifiedLevel += MobLevelingEventsMixin.getStructureLevelBonus(entity);
        }
        return modifiedLevel;
    }

    @WrapOperation(method={"applyAttributeBonus"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;heal(F)V")}, remap=true)
    private static void fixHeal(LivingEntity instance, float pHealAmount, Operation<Void> original, @Local(argsOnly=true) Attribute attribute) {
        if (attribute == Attributes.f_22276_) {
            instance.m_21153_(instance.m_21233_());
        }
    }

    @Unique
    private static int getStructureLevelBonus(LivingEntity entity) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        BlockPos pos = entity.m_20183_();
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        for (Structure structure : structureRegistry) {
            ResourceLocation structureId;
            StructureStart start = level.m_215010_().m_220494_(pos, structure);
            if (start == null || !start.m_73603_() || (structureId = structureRegistry.m_7981_((Object)structure)) == null) continue;
            return OtherworldConfig.get().getStructureLevelBonus(structureId);
        }
        return 0;
    }

    @Inject(method={"applyAttributeBonuses"}, at={@At(value="HEAD")}, cancellable=true)
    private static void applyEnhancedAttributeBonuses(LivingEntity entity, CallbackInfo ci) {
        EnhancedEntityLevelingSettings settings = EnhancedEntityLevelingSettingsReloader.getSettingsForEntity(entity.m_6095_());
        if (settings != null && !settings.getAttributeModifiers().isEmpty()) {
            int level = MobsLevelingEvents.getLevel((LivingEntity)entity);
            Otherworld.LOGGER.debug("Applying enhanced attribute bonuses for entity: {} with level: {}", (Object)entity.m_6095_().m_20676_(), (Object)level);
            settings.getAttributeModifiers().forEach((attribute, modifier) -> {
                double scaledAmount = modifier.m_22218_() * (double)level;
                Otherworld.LOGGER.debug("Applying modifier for attribute: {}, amount: {}, operation: {}", (Object)attribute.toString(), (Object)scaledAmount, (Object)modifier.m_22217_());
                MobLevelingEventsMixin.applyAttributeBonusIfPossible(entity, attribute, scaledAmount, modifier.m_22217_());
            });
            ci.cancel();
        }
    }

    @Unique
    private static void applyAttributeBonusIfPossible(LivingEntity entity, Attribute attribute, double bonus, AttributeModifier.Operation operation) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance == null) {
            return;
        }
        UUID modifierId = UUID.fromString("6a102cb4-d735-4cb7-8ab2-3d383219a44e");
        AttributeModifier existingModifier = attributeInstance.m_22111_(modifierId);
        if (existingModifier != null && existingModifier.m_22218_() == bonus && existingModifier.m_22217_() == operation) {
            return;
        }
        if (existingModifier != null) {
            attributeInstance.m_22130_(existingModifier);
        }
        AttributeModifier newModifier = new AttributeModifier(modifierId, "Auto Leveling Bonus", bonus, operation);
        attributeInstance.m_22125_(newModifier);
        if (attribute == Attributes.f_22276_) {
            entity.m_21153_(entity.m_21233_());
        }
    }
}

