/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.mixin;

import dev.muon.otherworld.event.HeartTransformEvents;
import dev.muon.otherworld.event.QuestItemEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    @Unique
    private static final ResourceLocation LIGHTNING_DRAGON_HEART_ID = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"lightning_dragon_heart");

    public ItemEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onItemEntityHurt(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        ItemEntity self = (ItemEntity)this;
        ItemStack stack = self.m_32055_();
        if (pSource.m_269533_(DamageTypeTags.f_268725_) && LIGHTNING_DRAGON_HEART_ID.equals((Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()))) {
            HeartTransformEvents.triggerTransformation(self, "lightning");
            cir.setReturnValue((Object)false);
            return;
        }
        if (QuestItemEvents.isQuestItem(stack) && !pSource.m_276093_(DamageTypes.f_268724_)) {
            cir.setReturnValue((Object)false);
        }
        if (LIGHTNING_DRAGON_HEART_ID.equals((Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) && !pSource.m_276093_(DamageTypes.f_268724_)) {
            cir.setReturnValue((Object)false);
            return;
        }
    }
}

