/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.muon.otherworld.world.saved_data.PortalFrameState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderEyeItem.class})
public class EnderEyeItemMixin {
    @Unique
    private static final ResourceLocation MALEDICTUS_ID = new ResourceLocation("legendary_monsters", "ancient_guardian");
    @Unique
    private static final ThreadLocal<Boolean> otherworld$isProcessingPortal = ThreadLocal.withInitial(() -> false);

    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;startUsingItem(Lnet/minecraft/world/InteractionHand;)V", shift=At.Shift.BEFORE)}, cancellable=true)
    private void otherworld$preventEyeThrowing(Level pLevel, Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!pLevel.f_46443_) {
            pPlayer.m_213846_((Component)Component.m_237113_((String)"The eye doesn't seem to be drawn to anything...").m_130940_(ChatFormatting.RED));
        }
        cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pHand)));
    }

    @WrapOperation(method={"useOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", ordinal=1)})
    private boolean otherworld$interceptPortalCreation(Level level, BlockPos pos, BlockState state, int flags, Operation<Boolean> original, @Local UseOnContext context, @Local(ordinal=0) BlockPattern.BlockPatternMatch patternMatch) {
        BlockPos spawnPos;
        Mob maledictus;
        if (!state.m_60713_(Blocks.f_50257_) || !(level instanceof ServerLevel)) {
            return (Boolean)original.call(new Object[]{level, pos, state, flags});
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (otherworld$isProcessingPortal.get().booleanValue()) {
            return false;
        }
        otherworld$isProcessingPortal.set(true);
        List<PortalFrameState.FrameData> frameDataList = this.otherworld$extractFrameData(patternMatch);
        EntityType maledictusType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(MALEDICTUS_ID);
        if (maledictusType != null && (maledictus = (Mob)maledictusType.m_262496_(serverLevel, spawnPos = patternMatch.m_61228_().m_7918_(-1, 1, -1), MobSpawnType.EVENT)) != null) {
            maledictus.m_5634_(maledictus.m_21233_());
            PortalFrameState.get(serverLevel).addPortal(maledictus.m_20148_(), frameDataList);
            BlockPos portalAreaStart = patternMatch.m_61228_().m_7918_(-3, 0, -3);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    level.m_7731_(portalAreaStart.m_7918_(i, 0, j), Blocks.f_50752_.m_49966_(), 2);
                }
            }
            level.m_6798_(1038, pos.m_7918_(-1, 0, -1), 0);
            return false;
        }
        otherworld$isProcessingPortal.set(false);
        return (Boolean)original.call(new Object[]{level, pos, state, flags});
    }

    @Inject(method={"useOn"}, at={@At(value="RETURN")})
    private void otherworld$resetPortalFlag(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        otherworld$isProcessingPortal.set(false);
    }

    @Unique
    private List<PortalFrameState.FrameData> otherworld$extractFrameData(BlockPattern.BlockPatternMatch patternMatch) {
        ArrayList<PortalFrameState.FrameData> frameDataList = new ArrayList<PortalFrameState.FrameData>();
        for (int palmOffset = 0; palmOffset < patternMatch.m_155970_(); ++palmOffset) {
            for (int fingerOffset = 0; fingerOffset < patternMatch.m_155972_(); ++fingerOffset) {
                for (int thumbOffset = 0; thumbOffset < patternMatch.m_155971_(); ++thumbOffset) {
                    BlockInWorld blockInWorld = patternMatch.m_61229_(palmOffset, thumbOffset, fingerOffset);
                    if (!blockInWorld.m_61168_().m_60713_(Blocks.f_50258_)) continue;
                    frameDataList.add(new PortalFrameState.FrameData(blockInWorld.m_61176_(), blockInWorld.m_61168_()));
                }
            }
        }
        return frameDataList;
    }
}

