/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.mixin;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.dimension.ElementalNexusTeleporter;
import dev.muon.otherworld.world.saved_data.EndPortalLinks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EndPortalBlock.class})
public class EndPortalBlockMixin {
    @Unique
    private static final BlockPos NEXUS_SPAWN_POS = new BlockPos(50, 69, 100);

    @Inject(method={"entityInside"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;changeDimension(Lnet/minecraft/server/level/ServerLevel;)Lnet/minecraft/world/entity/Entity;")}, cancellable=true)
    private void otherworld_redirectToNexus(BlockState state, Level level, BlockPos pos, Entity entity, CallbackInfo ci) {
        if (level.m_46472_() == Level.f_46428_ && entity instanceof ServerPlayer) {
            MinecraftServer server;
            ServerPlayer player = (ServerPlayer)entity;
            ci.cancel();
            Otherworld.LOGGER.info("Player {} entered End Portal from Overworld at {}, redirecting to Elemental Nexus", (Object)player.m_7755_().getString(), (Object)pos);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EndPortalLinks links = EndPortalLinks.get(serverLevel);
                links.setPortalPosition(player.m_20148_(), pos);
                Otherworld.LOGGER.debug("Stored portal entrance position {} for player {}", (Object)pos, (Object)player.m_7755_().getString());
            }
            if ((server = player.m_20194_()) != null) {
                boolean success = ElementalNexusTeleporter.teleportToElementalNexus(player, server, NEXUS_SPAWN_POS);
                if (!success) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.otherworld.end_portal.teleport_failed").m_130940_(ChatFormatting.RED), false);
                }
            } else {
                Otherworld.LOGGER.error("Could not get server instance to teleport player {} to Nexus!", (Object)player.m_7755_().getString());
                player.m_5661_((Component)Component.m_237115_((String)"message.otherworld.end_portal.teleport_failed").m_130940_(ChatFormatting.RED), false);
            }
        }
    }
}

