/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class MergeNbtModifier
extends LootModifier {
    public static final Supplier<Codec<MergeNbtModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> MergeNbtModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("target_item").forGetter(m -> m.targetItem)).and((App)CompoundTag.f_128325_.fieldOf("nbt_to_merge").forGetter(m -> m.nbtToMerge)).apply((Applicative)inst, MergeNbtModifier::new)));
    private final Item targetItem;
    private final CompoundTag nbtToMerge;

    public MergeNbtModifier(LootItemCondition[] conditionsIn, Item targetItemIn, CompoundTag nbtToMergeIn) {
        super(conditionsIn);
        this.targetItem = targetItemIn;
        this.nbtToMerge = nbtToMergeIn;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (ItemStack stack : generatedLoot) {
            if (stack.m_41720_() != this.targetItem) continue;
            CompoundTag existingTag = stack.m_41784_();
            existingTag.m_128391_(this.nbtToMerge);
            stack.m_41751_(existingTag);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

