/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddItemModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.STRING.fieldOf("generator").forGetter(m -> m.generatorMethod)).apply((Applicative)inst, AddItemModifier::new)));
    private final String generatorMethod;

    public AddItemModifier(LootItemCondition[] conditionsIn, String generatorMethod) {
        super(conditionsIn);
        this.generatorMethod = generatorMethod;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        try {
            String[] parts = this.generatorMethod.split("::");
            Class<?> clazz = Class.forName(parts[0]);
            Method method = clazz.getMethod(parts[1], new Class[0]);
            List items = (List)method.invoke(null, new Object[0]);
            generatedLoot.addAll((Collection)items);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

